(* ::Package:: *)

(* ::Title:: *)
(*Integration problems of the form x^m (a x+b x^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x+b x^2)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (b x+c x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^m*(b*x + c*x^2), x, 3, (b*x^(2 + m))/(2 + m) + (c*x^(3 + m))/(3 + m)}

{x^2*(b*x + c*x^2), x, 3, (b*x^4)/4 + (c*x^5)/5}
{x^1*(b*x + c*x^2), x, 3, (b*x^3)/3 + (c*x^4)/4}
{x^0*(b*x + c*x^2), x, 1, (b*x^2)/2 + (c*x^3)/3}
{(b*x + c*x^2)/x^1, x, 2, b*x + (c*x^2)/2}
{(b*x + c*x^2)/x^2, x, 3, c*x + b*Log[x]}
{(b*x + c*x^2)/x^3, x, 3, -(b/x) + c*Log[x]}
{(b*x + c*x^2)/x^4, x, 3, -(b/(2*x^2)) - c/x}
{(b*x + c*x^2)/x^5, x, 3, -(b/(3*x^3)) - c/(2*x^2)}
{(b*x + c*x^2)/x^6, x, 3, -(b/(4*x^4)) - c/(3*x^3)}


{x^m*(b*x + c*x^2)^2, x, 3, (b^2*x^(3 + m))/(3 + m) + (2*b*c*x^(4 + m))/(4 + m) + (c^2*x^(5 + m))/(5 + m)}

{x^2*(b*x + c*x^2)^2, x, 3, (b^2*x^5)/5 + (1/3)*b*c*x^6 + (c^2*x^7)/7}
{x^1*(b*x + c*x^2)^2, x, 3, (b^2*x^4)/4 + (2/5)*b*c*x^5 + (c^2*x^6)/6}
{x^0*(b*x + c*x^2)^2, x, 3, (b^2*x^3)/3 + (1/2)*b*c*x^4 + (c^2*x^5)/5}
{(b*x + c*x^2)^2/x^1, x, 3, (b^2*x^2)/2 + (2/3)*b*c*x^3 + (c^2*x^4)/4}
{(b*x + c*x^2)^2/x^2, x, 2, (b + c*x)^3/(3*c)}
{(b*x + c*x^2)^2/x^3, x, 3, 2*b*c*x + (c^2*x^2)/2 + b^2*Log[x]}
{(b*x + c*x^2)^2/x^4, x, 3, -(b^2/x) + c^2*x + 2*b*c*Log[x]}
{(b*x + c*x^2)^2/x^5, x, 3, -(b^2/(2*x^2)) - (2*b*c)/x + c^2*Log[x]}
{(b*x + c*x^2)^2/x^6, x, 2, -((b + c*x)^3/(3*b*x^3))}
{(b*x + c*x^2)^2/x^7, x, 3, -(b^2/(4*x^4)) - (2*b*c)/(3*x^3) - c^2/(2*x^2)}
{(b*x + c*x^2)^2/x^8, x, 3, -(b^2/(5*x^5)) - (b*c)/(2*x^4) - c^2/(3*x^3)}
{(b*x + c*x^2)^2/x^9, x, 3, -(b^2/(6*x^6)) - (2*b*c)/(5*x^5) - c^2/(4*x^4)}


{x^m*(b*x + c*x^2)^3, x, 3, (b^3*x^(4 + m))/(4 + m) + (3*b^2*c*x^(5 + m))/(5 + m) + (3*b*c^2*x^(6 + m))/(6 + m) + (c^3*x^(7 + m))/(7 + m)}

{x^1*(b*x + c*x^2)^3, x, 3, (b^3*x^5)/5 + (1/2)*b^2*c*x^6 + (3/7)*b*c^2*x^7 + (c^3*x^8)/8}
{x^0*(b*x + c*x^2)^3, x, 3, (b^3*x^4)/4 + (3/5)*b^2*c*x^5 + (1/2)*b*c^2*x^6 + (c^3*x^7)/7}
{(b*x + c*x^2)^3/x^1, x, 3, (b^3*x^3)/3 + (3/4)*b^2*c*x^4 + (3/5)*b*c^2*x^5 + (c^3*x^6)/6}
{(b*x + c*x^2)^3/x^2, x, 3, -((b*(b + c*x)^4)/(4*c^2)) + (b + c*x)^5/(5*c^2)}
{(b*x + c*x^2)^3/x^3, x, 2, (b + c*x)^4/(4*c)}
{(b*x + c*x^2)^3/x^4, x, 3, 3*b^2*c*x + (3/2)*b*c^2*x^2 + (c^3*x^3)/3 + b^3*Log[x]}
{(b*x + c*x^2)^3/x^5, x, 3, -(b^3/x) + 3*b*c^2*x + (c^3*x^2)/2 + 3*b^2*c*Log[x]}
{(b*x + c*x^2)^3/x^6, x, 3, -(b^3/(2*x^2)) - (3*b^2*c)/x + c^3*x + 3*b*c^2*Log[x]}
{(b*x + c*x^2)^3/x^7, x, 3, -(b^3/(3*x^3)) - (3*b^2*c)/(2*x^2) - (3*b*c^2)/x + c^3*Log[x]}
{(b*x + c*x^2)^3/x^8, x, 2, -((b + c*x)^4/(4*b*x^4))}
{(b*x + c*x^2)^3/x^9, x, 3, -(b^3/(5*x^5)) - (3*b^2*c)/(4*x^4) - (b*c^2)/x^3 - c^3/(2*x^2)}
{(b*x + c*x^2)^3/x^10, x, 3, -(b^3/(6*x^6)) - (3*b^2*c)/(5*x^5) - (3*b*c^2)/(4*x^4) - c^3/(3*x^3)}
{(b*x + c*x^2)^3/x^11, x, 3, -(b^3/(7*x^7)) - (b^2*c)/(2*x^6) - (3*b*c^2)/(5*x^5) - c^3/(4*x^4)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^5/(b*x + c*x^2), x, 3, -((b^3*x)/c^4) + (b^2*x^2)/(2*c^3) - (b*x^3)/(3*c^2) + x^4/(4*c) + (b^4*Log[b + c*x])/c^5}
{x^4/(b*x + c*x^2), x, 3, (b^2*x)/c^3 - (b*x^2)/(2*c^2) + x^3/(3*c) - (b^3*Log[b + c*x])/c^4}
{x^3/(b*x + c*x^2), x, 3, -((b*x)/c^2) + x^2/(2*c) + (b^2*Log[b + c*x])/c^3}
{x^2/(b*x + c*x^2), x, 3, x/c - (b*Log[b + c*x])/c^2}
{x^1/(b*x + c*x^2), x, 2, Log[b + c*x]/c}
{x^0/(b*x + c*x^2), x, 3, Log[x]/b - Log[b + c*x]/b}
{1/(x^1*(b*x + c*x^2)), x, 3, -(1/(b*x)) - (c*Log[x])/b^2 + (c*Log[b + c*x])/b^2}
{1/(x^2*(b*x + c*x^2)), x, 3, -(1/(2*b*x^2)) + c/(b^2*x) + (c^2*Log[x])/b^3 - (c^2*Log[b + c*x])/b^3}
{1/(x^3*(b*x + c*x^2)), x, 3, -(1/(3*b*x^3)) + c/(2*b^2*x^2) - c^2/(b^3*x) - (c^3*Log[x])/b^4 + (c^3*Log[b + c*x])/b^4}


{x^6/(b*x + c*x^2)^2, x, 3, (3*b^2*x)/c^4 - (b*x^2)/c^3 + x^3/(3*c^2) - b^4/(c^5*(b + c*x)) - (4*b^3*Log[b + c*x])/c^5}
{x^5/(b*x + c*x^2)^2, x, 3, -((2*b*x)/c^3) + x^2/(2*c^2) + b^3/(c^4*(b + c*x)) + (3*b^2*Log[b + c*x])/c^4}
{x^4/(b*x + c*x^2)^2, x, 3, x/c^2 - b^2/(c^3*(b + c*x)) - (2*b*Log[b + c*x])/c^3}
{x^3/(b*x + c*x^2)^2, x, 3, b/(c^2*(b + c*x)) + Log[b + c*x]/c^2}
{x^2/(b*x + c*x^2)^2, x, 2, -(1/(c*(b + c*x)))}
{x^1/(b*x + c*x^2)^2, x, 3, 1/(b*(b + c*x)) + Log[x]/b^2 - Log[b + c*x]/b^2}
{x^0/(b*x + c*x^2)^2, x, 3, -(1/(b^2*x)) - c/(b^2*(b + c*x)) - (2*c*Log[x])/b^3 + (2*c*Log[b + c*x])/b^3}
{1/(x^1*(b*x + c*x^2)^2), x, 3, -(1/(2*b^2*x^2)) + (2*c)/(b^3*x) + c^2/(b^3*(b + c*x)) + (3*c^2*Log[x])/b^4 - (3*c^2*Log[b + c*x])/b^4}
{1/(x^2*(b*x + c*x^2)^2), x, 3, -(1/(3*b^2*x^3)) + c/(b^3*x^2) - (3*c^2)/(b^4*x) - c^3/(b^4*(b + c*x)) - (4*c^3*Log[x])/b^5 + (4*c^3*Log[b + c*x])/b^5}


{x^8/(b*x + c*x^2)^3, x, 3, (6*b^2*x)/c^5 - (3*b*x^2)/(2*c^4) + x^3/(3*c^3) + b^5/(2*c^6*(b + c*x)^2) - (5*b^4)/(c^6*(b + c*x)) - (10*b^3*Log[b + c*x])/c^6}
{x^7/(b*x + c*x^2)^3, x, 3, -((3*b*x)/c^4) + x^2/(2*c^3) - b^4/(2*c^5*(b + c*x)^2) + (4*b^3)/(c^5*(b + c*x)) + (6*b^2*Log[b + c*x])/c^5}
{x^6/(b*x + c*x^2)^3, x, 3, x/c^3 + b^3/(2*c^4*(b + c*x)^2) - (3*b^2)/(c^4*(b + c*x)) - (3*b*Log[b + c*x])/c^4}
{x^5/(b*x + c*x^2)^3, x, 3, -(b^2/(2*c^3*(b + c*x)^2)) + (2*b)/(c^3*(b + c*x)) + Log[b + c*x]/c^3}
{x^4/(b*x + c*x^2)^3, x, 2, x^2/(2*b*(b + c*x)^2)}
{x^3/(b*x + c*x^2)^3, x, 2, -(1/(2*c*(b + c*x)^2))}
{x^2/(b*x + c*x^2)^3, x, 3, 1/(2*b*(b + c*x)^2) + 1/(b^2*(b + c*x)) + Log[x]/b^3 - Log[b + c*x]/b^3}
{x^1/(b*x + c*x^2)^3, x, 3, -(1/(b^3*x)) - c/(2*b^2*(b + c*x)^2) - (2*c)/(b^3*(b + c*x)) - (3*c*Log[x])/b^4 + (3*c*Log[b + c*x])/b^4}
{x^0/(b*x + c*x^2)^3, x, 3, -(1/(2*b^3*x^2)) + (3*c)/(b^4*x) + c^2/(2*b^3*(b + c*x)^2) + (3*c^2)/(b^4*(b + c*x)) + (6*c^2*Log[x])/b^5 - (6*c^2*Log[b + c*x])/b^5}
{1/(x^1*(b*x + c*x^2)^3), x, 3, -(1/(3*b^3*x^3)) + (3*c)/(2*b^4*x^2) - (6*c^2)/(b^5*x) - c^3/(2*b^4*(b + c*x)^2) - (4*c^3)/(b^5*(b + c*x)) - (10*c^3*Log[x])/b^6 + (10*c^3*Log[b + c*x])/b^6}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (b x+c x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*(b*x + c*x^2)^(1/2), x, 6, -((7*b^4*Sqrt[b*x + c*x^2])/(128*c^4)) + (7*b^3*x*Sqrt[b*x + c*x^2])/(192*c^3) - (7*b^2*x^2*Sqrt[b*x + c*x^2])/(240*c^2) + (b*x^3*Sqrt[b*x + c*x^2])/(40*c) + (1/5)*x^4*Sqrt[b*x + c*x^2] + (7*b^5*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(128*c^(9/2))}
{x^2*(b*x + c*x^2)^(1/2), x, 5, (5*b^3*Sqrt[b*x + c*x^2])/(64*c^3) - (5*b^2*x*Sqrt[b*x + c*x^2])/(96*c^2) + (b*x^2*Sqrt[b*x + c*x^2])/(24*c) + (1/4)*x^3*Sqrt[b*x + c*x^2] - (5*b^4*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(64*c^(7/2))}
{x^1*(b*x + c*x^2)^(1/2), x, 4, -((b^2*Sqrt[b*x + c*x^2])/(8*c^2)) + (b*x*Sqrt[b*x + c*x^2])/(12*c) + (1/3)*x^2*Sqrt[b*x + c*x^2] + (b^3*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(8*c^(5/2))}
{x^0*(b*x + c*x^2)^(1/2), x, 3, (b*Sqrt[b*x + c*x^2])/(4*c) + (1/2)*x*Sqrt[b*x + c*x^2] - (b^2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(4*c^(3/2))}
{(b*x + c*x^2)^(1/2)/x^1, x, 2, Sqrt[b*x + c*x^2] + (b*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/Sqrt[c]}
{(b*x + c*x^2)^(1/2)/x^2, x, 2, -((2*Sqrt[b*x + c*x^2])/x) + 2*Sqrt[c]*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]]}
{(b*x + c*x^2)^(1/2)/x^3, x, 1, -((2*(b*x + c*x^2)^(3/2))/(3*b*x^3))}
{(b*x + c*x^2)^(1/2)/x^4, x, 2, -((2*(b*x + c*x^2)^(3/2))/(5*b*x^4)) + (4*c*(b*x + c*x^2)^(3/2))/(15*b^2*x^3)}
{(b*x + c*x^2)^(1/2)/x^5, x, 3, -((2*(b*x + c*x^2)^(3/2))/(7*b*x^5)) + (8*c*(b*x + c*x^2)^(3/2))/(35*b^2*x^4) - (16*c^2*(b*x + c*x^2)^(3/2))/(105*b^3*x^3)}
{(b*x + c*x^2)^(1/2)/x^6, x, 4, -((2*(b*x + c*x^2)^(3/2))/(9*b*x^6)) + (4*c*(b*x + c*x^2)^(3/2))/(21*b^2*x^5) - (16*c^2*(b*x + c*x^2)^(3/2))/(105*b^3*x^4) + (32*c^3*(b*x + c*x^2)^(3/2))/(315*b^4*x^3)}
{(b*x + c*x^2)^(1/2)/x^7, x, 5, -((2*(b*x + c*x^2)^(3/2))/(11*b*x^7)) + (16*c*(b*x + c*x^2)^(3/2))/(99*b^2*x^6) - (32*c^2*(b*x + c*x^2)^(3/2))/(231*b^3*x^5) + (128*c^3*(b*x + c*x^2)^(3/2))/(1155*b^4*x^4) - (256*c^4*(b*x + c*x^2)^(3/2))/(3465*b^5*x^3)}


{x^2*(b*x + c*x^2)^(3/2), x, 7, -((7*b^5*Sqrt[b*x + c*x^2])/(512*c^4)) + (7*b^4*x*Sqrt[b*x + c*x^2])/(768*c^3) - (7*b^3*x^2*Sqrt[b*x + c*x^2])/(960*c^2) + (b^2*x^3*Sqrt[b*x + c*x^2])/(160*c) + (1/20)*b*x^4*Sqrt[b*x + c*x^2] + (1/6)*x^3*(b*x + c*x^2)^(3/2) + (7*b^6*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(512*c^(9/2))}
{x^1*(b*x + c*x^2)^(3/2), x, 6, (3*b^4*Sqrt[b*x + c*x^2])/(128*c^3) - (b^3*x*Sqrt[b*x + c*x^2])/(64*c^2) + (b^2*x^2*Sqrt[b*x + c*x^2])/(80*c) + (3/40)*b*x^3*Sqrt[b*x + c*x^2] + (1/5)*x^2*(b*x + c*x^2)^(3/2) - (3*b^5*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(128*c^(7/2))}
{x^0*(b*x + c*x^2)^(3/2), x, 5, -((3*b^3*Sqrt[b*x + c*x^2])/(64*c^2)) + (b^2*x*Sqrt[b*x + c*x^2])/(32*c) + (1/8)*b*x^2*Sqrt[b*x + c*x^2] + (1/4)*x*(b*x + c*x^2)^(3/2) + (3*b^4*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(64*c^(5/2))}
{(b*x + c*x^2)^(3/2)/x^1, x, 4, (b^2*Sqrt[b*x + c*x^2])/(8*c) + (1/4)*b*x*Sqrt[b*x + c*x^2] + (1/3)*(b*x + c*x^2)^(3/2) - (b^3*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(8*c^(3/2))}
{(b*x + c*x^2)^(3/2)/x^2, x, 3, (3/4)*b*Sqrt[b*x + c*x^2] + (b*x + c*x^2)^(3/2)/(2*x) + (3*b^2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(4*Sqrt[c])}
{(b*x + c*x^2)^(3/2)/x^3, x, 3, 3*c*Sqrt[b*x + c*x^2] - (2*(b*x + c*x^2)^(3/2))/x^2 + 3*b*Sqrt[c]*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]]}
{(b*x + c*x^2)^(3/2)/x^4, x, 3, -((2*c*Sqrt[b*x + c*x^2])/x) - (2*(b*x + c*x^2)^(3/2))/(3*x^3) + 2*c^(3/2)*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]]}
{(b*x + c*x^2)^(3/2)/x^5, x, 1, -((2*(b*x + c*x^2)^(5/2))/(5*b*x^5))}
{(b*x + c*x^2)^(3/2)/x^6, x, 2, -((2*(b*x + c*x^2)^(5/2))/(7*b*x^6)) + (4*c*(b*x + c*x^2)^(5/2))/(35*b^2*x^5)}
{(b*x + c*x^2)^(3/2)/x^7, x, 3, -((2*(b*x + c*x^2)^(5/2))/(9*b*x^7)) + (8*c*(b*x + c*x^2)^(5/2))/(63*b^2*x^6) - (16*c^2*(b*x + c*x^2)^(5/2))/(315*b^3*x^5)}
{(b*x + c*x^2)^(3/2)/x^8, x, 4, -((2*(b*x + c*x^2)^(5/2))/(11*b*x^8)) + (4*c*(b*x + c*x^2)^(5/2))/(33*b^2*x^7) - (16*c^2*(b*x + c*x^2)^(5/2))/(231*b^3*x^6) + (32*c^3*(b*x + c*x^2)^(5/2))/(1155*b^4*x^5)}
{(b*x + c*x^2)^(3/2)/x^9, x, 5, -((2*(b*x + c*x^2)^(5/2))/(13*b*x^9)) + (16*c*(b*x + c*x^2)^(5/2))/(143*b^2*x^8) - (32*c^2*(b*x + c*x^2)^(5/2))/(429*b^3*x^7) + (128*c^3*(b*x + c*x^2)^(5/2))/(3003*b^4*x^6) - (256*c^4*(b*x + c*x^2)^(5/2))/(15015*b^5*x^5)}


{x^2*(a*x + b*x^2)^(5/2), x, 9, (45*a^7*Sqrt[a*x + b*x^2])/(16384*b^5) - (15*a^6*x*Sqrt[a*x + b*x^2])/(8192*b^4) + (3*a^5*x^2*Sqrt[a*x + b*x^2])/(2048*b^3) - (9*a^4*x^3*Sqrt[a*x + b*x^2])/(7168*b^2) + (a^3*x^4*Sqrt[a*x + b*x^2])/(896*b) + (5/448)*a^2*x^5*Sqrt[a*x + b*x^2] + (5/112)*a*x^4*(a*x + b*x^2)^(3/2) + (1/8)*x^3*(a*x + b*x^2)^(5/2) - (45*a^8*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(16384*b^(11/2))}
{x^1*(a*x + b*x^2)^(5/2), x, 8, -((5*a^6*Sqrt[a*x + b*x^2])/(1024*b^4)) + (5*a^5*x*Sqrt[a*x + b*x^2])/(1536*b^3) - (a^4*x^2*Sqrt[a*x + b*x^2])/(384*b^2) + (a^3*x^3*Sqrt[a*x + b*x^2])/(448*b) + (1/56)*a^2*x^4*Sqrt[a*x + b*x^2] + (5/84)*a*x^3*(a*x + b*x^2)^(3/2) + (1/7)*x^2*(a*x + b*x^2)^(5/2) + (5*a^7*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(1024*b^(9/2))}
{x^0*(a*x + b*x^2)^(5/2), x, 7, (5*a^5*Sqrt[a*x + b*x^2])/(512*b^3) - (5*a^4*x*Sqrt[a*x + b*x^2])/(768*b^2) + (a^3*x^2*Sqrt[a*x + b*x^2])/(192*b) + (1/32)*a^2*x^3*Sqrt[a*x + b*x^2] + (1/12)*a*x^2*(a*x + b*x^2)^(3/2) + (1/6)*x*(a*x + b*x^2)^(5/2) - (5*a^6*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(512*b^(7/2))}
{(a*x + b*x^2)^(5/2)/x^1, x, 6, -((3*a^4*Sqrt[a*x + b*x^2])/(128*b^2)) + (a^3*x*Sqrt[a*x + b*x^2])/(64*b) + (1/16)*a^2*x^2*Sqrt[a*x + b*x^2] + (1/8)*a*x*(a*x + b*x^2)^(3/2) + (1/5)*(a*x + b*x^2)^(5/2) + (3*a^5*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(128*b^(5/2))}
{(a*x + b*x^2)^(5/2)/x^2, x, 5, (5*a^3*Sqrt[a*x + b*x^2])/(64*b) + (5/32)*a^2*x*Sqrt[a*x + b*x^2] + (5/24)*a*(a*x + b*x^2)^(3/2) + (a*x + b*x^2)^(5/2)/(4*x) - (5*a^4*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(64*b^(3/2))}
{(a*x + b*x^2)^(5/2)/x^3, x, 4, (5/8)*a^2*Sqrt[a*x + b*x^2] + (5*a*(a*x + b*x^2)^(3/2))/(12*x) + (a*x + b*x^2)^(5/2)/(3*x^2) + (5*a^3*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(8*Sqrt[b])}
{(a*x + b*x^2)^(5/2)/x^4, x, 4, (15/4)*a*b*Sqrt[a*x + b*x^2] + (5*b*(a*x + b*x^2)^(3/2))/(2*x) - (2*(a*x + b*x^2)^(5/2))/x^3 + (15/4)*a^2*Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]]}
{(a*x + b*x^2)^(5/2)/x^5, x, 4, 5*b^2*Sqrt[a*x + b*x^2] - (10*b*(a*x + b*x^2)^(3/2))/(3*x^2) - (2*(a*x + b*x^2)^(5/2))/(3*x^4) + 5*a*b^(3/2)*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]]}
{(a*x + b*x^2)^(5/2)/x^6, x, 4, -((2*b^2*Sqrt[a*x + b*x^2])/x) - (2*b*(a*x + b*x^2)^(3/2))/(3*x^3) - (2*(a*x + b*x^2)^(5/2))/(5*x^5) + 2*b^(5/2)*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]]}
{(a*x + b*x^2)^(5/2)/x^7, x, 1, -((2*(a*x + b*x^2)^(7/2))/(7*a*x^7))}
{(a*x + b*x^2)^(5/2)/x^8, x, 2, -((2*(a*x + b*x^2)^(7/2))/(9*a*x^8)) + (4*b*(a*x + b*x^2)^(7/2))/(63*a^2*x^7)}
{(a*x + b*x^2)^(5/2)/x^9, x, 3, -((2*(a*x + b*x^2)^(7/2))/(11*a*x^9)) + (8*b*(a*x + b*x^2)^(7/2))/(99*a^2*x^8) - (16*b^2*(a*x + b*x^2)^(7/2))/(693*a^3*x^7)}
{(a*x + b*x^2)^(5/2)/x^10, x, 4, -((2*(a*x + b*x^2)^(7/2))/(13*a*x^10)) + (12*b*(a*x + b*x^2)^(7/2))/(143*a^2*x^9) - (16*b^2*(a*x + b*x^2)^(7/2))/(429*a^3*x^8) + (32*b^3*(a*x + b*x^2)^(7/2))/(3003*a^4*x^7)}
{(a*x + b*x^2)^(5/2)/x^11, x, 5, -((2*(a*x + b*x^2)^(7/2))/(15*a*x^11)) + (16*b*(a*x + b*x^2)^(7/2))/(195*a^2*x^10) - (32*b^2*(a*x + b*x^2)^(7/2))/(715*a^3*x^9) + (128*b^3*(a*x + b*x^2)^(7/2))/(6435*a^4*x^8) - (256*b^4*(a*x + b*x^2)^(7/2))/(45045*a^5*x^7)}
{(a*x + b*x^2)^(5/2)/x^12, x, 6, -((2*(a*x + b*x^2)^(7/2))/(17*a*x^12)) + (4*b*(a*x + b*x^2)^(7/2))/(51*a^2*x^11) - (32*b^2*(a*x + b*x^2)^(7/2))/(663*a^3*x^10) + (64*b^3*(a*x + b*x^2)^(7/2))/(2431*a^4*x^9) - (256*b^4*(a*x + b*x^2)^(7/2))/(21879*a^5*x^8) + (512*b^5*(a*x + b*x^2)^(7/2))/(153153*a^6*x^7)}


{(b*x + c*x^2)^(7/2), x, 9, -((35*b^7*Sqrt[b*x + c*x^2])/(16384*c^4)) + (35*b^6*x*Sqrt[b*x + c*x^2])/(24576*c^3) - (7*b^5*x^2*Sqrt[b*x + c*x^2])/(6144*c^2) + (b^4*x^3*Sqrt[b*x + c*x^2])/(1024*c) + (1/128)*b^3*x^4*Sqrt[b*x + c*x^2] + (5/192)*b^2*x^3*(b*x + c*x^2)^(3/2) + (1/16)*b*x^2*(b*x + c*x^2)^(5/2) + (1/8)*x*(b*x + c*x^2)^(7/2) + (35*b^8*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(16384*c^(9/2))}


{(3*I*x + 4*x^2)^(7/2), x, 9, (76545*I*Sqrt[3*I*x + 4*x^2])/4194304 - (8505*x*Sqrt[3*I*x + 4*x^2])/524288 - (567*I*x^2*Sqrt[3*I*x + 4*x^2])/32768 + (81*x^3*Sqrt[3*I*x + 4*x^2])/4096 - (27/128)*I*x^4*Sqrt[3*I*x + 4*x^2] - (15/64)*x^3*(3*I*x + 4*x^2)^(3/2) + (3/16)*I*x^2*(3*I*x + 4*x^2)^(5/2) + (1/8)*x*(3*I*x + 4*x^2)^(7/2) + (229635*I*ArcSin[1 - (8*I*x)/3])/16777216}
{(3*I*x + 4*x^2)^(5/2), x, 7, (1215*I*Sqrt[3*I*x + 4*x^2])/32768 - (135*x*Sqrt[3*I*x + 4*x^2])/4096 - (9/256)*I*x^2*Sqrt[3*I*x + 4*x^2] - (9/32)*x^3*Sqrt[3*I*x + 4*x^2] + (1/4)*I*x^2*(3*I*x + 4*x^2)^(3/2) + (1/6)*x*(3*I*x + 4*x^2)^(5/2) + (3645*I*ArcSin[1 - (8*I*x)/3])/131072}
{(3*I*x + 4*x^2)^(3/2), x, 5, (81*I*Sqrt[3*I*x + 4*x^2])/1024 - (9/128)*x*Sqrt[3*I*x + 4*x^2] + (3/8)*I*x^2*Sqrt[3*I*x + 4*x^2] + (1/4)*x*(3*I*x + 4*x^2)^(3/2) + (243*I*ArcSin[1 - (8*I*x)/3])/4096}
{(3*I*x + 4*x^2)^(1/2), x, 3, (3/16)*I*Sqrt[3*I*x + 4*x^2] + (1/2)*x*Sqrt[3*I*x + 4*x^2] + (9/64)*I*ArcSin[1 - (8*I*x)/3]}


{(3*x - 4*x^2)^(7/2), x, 9, -((76545*Sqrt[3*x - 4*x^2])/4194304) - (8505*x*Sqrt[3*x - 4*x^2])/524288 - (567*x^2*Sqrt[3*x - 4*x^2])/32768 - (81*x^3*Sqrt[3*x - 4*x^2])/4096 + (27/128)*x^4*Sqrt[3*x - 4*x^2] + (15/64)*x^3*(3*x - 4*x^2)^(3/2) + (3/16)*x^2*(3*x - 4*x^2)^(5/2) + (1/8)*x*(3*x - 4*x^2)^(7/2) - (229635*ArcSin[1 - (8*x)/3])/16777216}
{(3*x - 4*x^2)^(5/2), x, 7, -((1215*Sqrt[3*x - 4*x^2])/32768) - (135*x*Sqrt[3*x - 4*x^2])/4096 - (9/256)*x^2*Sqrt[3*x - 4*x^2] + (9/32)*x^3*Sqrt[3*x - 4*x^2] + (1/4)*x^2*(3*x - 4*x^2)^(3/2) + (1/6)*x*(3*x - 4*x^2)^(5/2) - (3645*ArcSin[1 - (8*x)/3])/131072}
{(3*x - 4*x^2)^(3/2), x, 5, -((81*Sqrt[3*x - 4*x^2])/1024) - (9/128)*x*Sqrt[3*x - 4*x^2] + (3/8)*x^2*Sqrt[3*x - 4*x^2] + (1/4)*x*(3*x - 4*x^2)^(3/2) - (243*ArcSin[1 - (8*x)/3])/4096}
{(3*x - 4*x^2)^(1/2), x, 3, (-(3/16))*Sqrt[3*x - 4*x^2] + (1/2)*x*Sqrt[3*x - 4*x^2] - (9/64)*ArcSin[1 - (8*x)/3]}


{Sqrt[6*x - x^2], x, 3, (-(3/2))*Sqrt[6*x - x^2] + (1/2)*x*Sqrt[6*x - x^2] - (9/2)*ArcSin[1 - x/3]}
{Sqrt[5*x - 9*x^2], x, 3, (-(5/36))*Sqrt[5*x - 9*x^2] + (1/2)*x*Sqrt[5*x - 9*x^2] - (25/216)*ArcSin[1 - (18*x)/5]}

{Sqrt[4*x + x^2], x, 3, Sqrt[4*x + x^2] + (1/2)*x*Sqrt[4*x + x^2] - 4*ArcTanh[x/Sqrt[4*x + x^2]]}
{Sqrt[-8*x + x^2], x, 3, -2*Sqrt[-8*x + x^2] + (1/2)*x*Sqrt[-8*x + x^2] - 16*ArcTanh[x/Sqrt[-8*x + x^2]]}
{Sqrt[-x + x^2], x, 3, (-(1/4))*Sqrt[-x + x^2] + (1/2)*x*Sqrt[-x + x^2] - (1/4)*ArcTanh[x/Sqrt[-x + x^2]]}

{(x - x^2)^(3/2), x, 5, (-(3/64))*Sqrt[x - x^2] - (1/32)*x*Sqrt[x - x^2] + (1/8)*x^2*Sqrt[x - x^2] + (1/4)*x*(x - x^2)^(3/2) - (3/128)*ArcSin[1 - 2*x]}


{x*Sqrt[2*x - x^2], x, 4, (-(1/2))*Sqrt[2*x - x^2] - (1/6)*x*Sqrt[2*x - x^2] + (1/3)*x^2*Sqrt[2*x - x^2] - (1/2)*ArcSin[1 - x]}
{x*Sqrt[3*x - 4*x^2], x, 4, (-(9/128))*Sqrt[3*x - 4*x^2] - (1/16)*x*Sqrt[3*x - 4*x^2] + (1/3)*x^2*Sqrt[3*x - 4*x^2] - (27/512)*ArcSin[1 - (8*x)/3]}
{x*Sqrt[x + x^2], x, 4, (-(1/8))*Sqrt[x + x^2] + (1/12)*x*Sqrt[x + x^2] + (1/3)*x^2*Sqrt[x + x^2] + (1/8)*ArcTanh[x/Sqrt[x + x^2]]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/(b*x + c*x^2)^(1/2), x, 5, -((35*b^3*Sqrt[b*x + c*x^2])/(64*c^4)) + (35*b^2*x*Sqrt[b*x + c*x^2])/(96*c^3) - (7*b*x^2*Sqrt[b*x + c*x^2])/(24*c^2) + (x^3*Sqrt[b*x + c*x^2])/(4*c) + (35*b^4*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(64*c^(9/2))}
{x^3/(b*x + c*x^2)^(1/2), x, 4, (5*b^2*Sqrt[b*x + c*x^2])/(8*c^3) - (5*b*x*Sqrt[b*x + c*x^2])/(12*c^2) + (x^2*Sqrt[b*x + c*x^2])/(3*c) - (5*b^3*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(8*c^(7/2))}
{x^2/(b*x + c*x^2)^(1/2), x, 3, -((3*b*Sqrt[b*x + c*x^2])/(4*c^2)) + (x*Sqrt[b*x + c*x^2])/(2*c) + (3*b^2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(4*c^(5/2))}
{x^1/(b*x + c*x^2)^(1/2), x, 2, Sqrt[b*x + c*x^2]/c - (b*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/c^(3/2)}
{x^0/(b*x + c*x^2)^(1/2), x, 1, (2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/Sqrt[c]}
{1/(x^1*(b*x + c*x^2)^(1/2)), x, 1, -((2*Sqrt[b*x + c*x^2])/(b*x))}
{1/(x^2*(b*x + c*x^2)^(1/2)), x, 2, -((2*Sqrt[b*x + c*x^2])/(3*b*x^2)) + (4*c*Sqrt[b*x + c*x^2])/(3*b^2*x)}
{1/(x^3*(b*x + c*x^2)^(1/2)), x, 3, -((2*Sqrt[b*x + c*x^2])/(5*b*x^3)) + (8*c*Sqrt[b*x + c*x^2])/(15*b^2*x^2) - (16*c^2*Sqrt[b*x + c*x^2])/(15*b^3*x)}
{1/(x^4*(b*x + c*x^2)^(1/2)), x, 4, -((2*Sqrt[b*x + c*x^2])/(7*b*x^4)) + (12*c*Sqrt[b*x + c*x^2])/(35*b^2*x^3) - (16*c^2*Sqrt[b*x + c*x^2])/(35*b^3*x^2) + (32*c^3*Sqrt[b*x + c*x^2])/(35*b^4*x)}
{1/(x^5*(b*x + c*x^2)^(1/2)), x, 5, -((2*Sqrt[b*x + c*x^2])/(9*b*x^5)) + (16*c*Sqrt[b*x + c*x^2])/(63*b^2*x^4) - (32*c^2*Sqrt[b*x + c*x^2])/(105*b^3*x^3) + (128*c^3*Sqrt[b*x + c*x^2])/(315*b^4*x^2) - (256*c^4*Sqrt[b*x + c*x^2])/(315*b^5*x)}


{x^4/(b*x + c*x^2)^(3/2), x, 4, -((2*x^3)/(c*Sqrt[b*x + c*x^2])) - (15*b*Sqrt[b*x + c*x^2])/(4*c^3) + (5*x*Sqrt[b*x + c*x^2])/(2*c^2) + (15*b^2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/(4*c^(7/2))}
{x^3/(b*x + c*x^2)^(3/2), x, 3, -((2*x^2)/(c*Sqrt[b*x + c*x^2])) + (3*Sqrt[b*x + c*x^2])/c^2 - (3*b*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/c^(5/2)}
{x^2/(b*x + c*x^2)^(3/2), x, 2, -((2*x)/(c*Sqrt[b*x + c*x^2])) + (2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/c^(3/2)}
{x^1/(b*x + c*x^2)^(3/2), x, 1, (2*x)/(b*Sqrt[b*x + c*x^2])}
{x^0/(b*x + c*x^2)^(3/2), x, 2, 2/(b*Sqrt[b*x + c*x^2]) - (4*Sqrt[b*x + c*x^2])/(b^2*x)}
{1/(x^1*(b*x + c*x^2)^(3/2)), x, 3, 2/(b*x*Sqrt[b*x + c*x^2]) - (8*Sqrt[b*x + c*x^2])/(3*b^2*x^2) + (16*c*Sqrt[b*x + c*x^2])/(3*b^3*x)}
{1/(x^2*(b*x + c*x^2)^(3/2)), x, 4, 2/(b*x^2*Sqrt[b*x + c*x^2]) - (12*Sqrt[b*x + c*x^2])/(5*b^2*x^3) + (16*c*Sqrt[b*x + c*x^2])/(5*b^3*x^2) - (32*c^2*Sqrt[b*x + c*x^2])/(5*b^4*x)}
{1/(x^3*(b*x + c*x^2)^(3/2)), x, 5, 2/(b*x^3*Sqrt[b*x + c*x^2]) - (16*Sqrt[b*x + c*x^2])/(7*b^2*x^4) + (96*c*Sqrt[b*x + c*x^2])/(35*b^3*x^3) - (128*c^2*Sqrt[b*x + c*x^2])/(35*b^4*x^2) + (256*c^3*Sqrt[b*x + c*x^2])/(35*b^5*x)}


{x^6/(a*x + b*x^2)^(5/2), x, 5, -((2*x^5)/(3*b*(a*x + b*x^2)^(3/2))) - (14*x^3)/(3*b^2*Sqrt[a*x + b*x^2]) - (35*a*Sqrt[a*x + b*x^2])/(4*b^4) + (35*x*Sqrt[a*x + b*x^2])/(6*b^3) + (35*a^2*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/(4*b^(9/2))}
{x^5/(a*x + b*x^2)^(5/2), x, 4, -((2*x^4)/(3*b*(a*x + b*x^2)^(3/2))) - (10*x^2)/(3*b^2*Sqrt[a*x + b*x^2]) + (5*Sqrt[a*x + b*x^2])/b^3 - (5*a*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/b^(7/2)}
{x^4/(a*x + b*x^2)^(5/2), x, 3, -((2*x^3)/(3*b*(a*x + b*x^2)^(3/2))) - (2*x)/(b^2*Sqrt[a*x + b*x^2]) + (2*ArcTanh[(Sqrt[b]*x)/Sqrt[a*x + b*x^2]])/b^(5/2)}
{x^3/(a*x + b*x^2)^(5/2), x, 1, (2*x^3)/(3*a*(a*x + b*x^2)^(3/2))}
{x^2/(a*x + b*x^2)^(5/2), x, 2, (2*x^2)/(3*a*(a*x + b*x^2)^(3/2)) + (4*x)/(3*a^2*Sqrt[a*x + b*x^2])}
{x^1/(a*x + b*x^2)^(5/2), x, 3, (2*x)/(3*a*(a*x + b*x^2)^(3/2)) + 8/(3*a^2*Sqrt[a*x + b*x^2]) - (16*Sqrt[a*x + b*x^2])/(3*a^3*x)}
{x^0/(a*x + b*x^2)^(5/2), x, 4, 2/(3*a*(a*x + b*x^2)^(3/2)) + 4/(a^2*x*Sqrt[a*x + b*x^2]) - (16*Sqrt[a*x + b*x^2])/(3*a^3*x^2) + (32*b*Sqrt[a*x + b*x^2])/(3*a^4*x)}
{1/(x^1*(a*x + b*x^2)^(5/2)), x, 5, 2/(3*a*x*(a*x + b*x^2)^(3/2)) + 16/(3*a^2*x^2*Sqrt[a*x + b*x^2]) - (32*Sqrt[a*x + b*x^2])/(5*a^3*x^3) + (128*b*Sqrt[a*x + b*x^2])/(15*a^4*x^2) - (256*b^2*Sqrt[a*x + b*x^2])/(15*a^5*x)}
{1/(x^2*(a*x + b*x^2)^(5/2)), x, 6, 2/(3*a*x^2*(a*x + b*x^2)^(3/2)) + 20/(3*a^2*x^3*Sqrt[a*x + b*x^2]) - (160*Sqrt[a*x + b*x^2])/(21*a^3*x^4) + (64*b*Sqrt[a*x + b*x^2])/(7*a^4*x^3) - (256*b^2*Sqrt[a*x + b*x^2])/(21*a^5*x^2) + (512*b^3*Sqrt[a*x + b*x^2])/(21*a^6*x)}


{1/(b*x + c*x^2)^(7/2), x, 6, 2/(5*b*(b*x + c*x^2)^(5/2)) + 4/(3*b^2*x*(b*x + c*x^2)^(3/2)) + 32/(3*b^3*x^2*Sqrt[b*x + c*x^2]) - (64*Sqrt[b*x + c*x^2])/(5*b^4*x^3) + (256*c*Sqrt[b*x + c*x^2])/(15*b^5*x^2) - (512*c^2*Sqrt[b*x + c*x^2])/(15*b^6*x)}


{1/(3*I*x + 4*x^2)^(1/2), x, 1, (1/2)*I*ArcSin[1 - (8*I*x)/3]}
{1/(3*I*x + 4*x^2)^(3/2), x, 2, -((2*I)/(3*Sqrt[3*I*x + 4*x^2])) + (4*Sqrt[3*I*x + 4*x^2])/(9*x)}
{1/(3*I*x + 4*x^2)^(5/2), x, 4, -((2*I)/(9*(3*I*x + 4*x^2)^(3/2))) - 4/(9*x*Sqrt[3*I*x + 4*x^2]) - (16*I*Sqrt[3*I*x + 4*x^2])/(81*x^2) + (128*Sqrt[3*I*x + 4*x^2])/(243*x)}
{1/(3*I*x + 4*x^2)^(7/2), x, 6, -((2*I)/(15*(3*I*x + 4*x^2)^(5/2))) - 4/(27*x*(3*I*x + 4*x^2)^(3/2)) + (32*I)/(81*x^2*Sqrt[3*I*x + 4*x^2]) - (64*Sqrt[3*I*x + 4*x^2])/(405*x^3) - (1024*I*Sqrt[3*I*x + 4*x^2])/(3645*x^2) + (8192*Sqrt[3*I*x + 4*x^2])/(10935*x)}


{1/(3*x - 4*x^2)^(1/2), x, 1, (-(1/2))*ArcSin[1 - (8*x)/3]}
{1/(3*x - 4*x^2)^(3/2), x, 2, 2/(3*Sqrt[3*x - 4*x^2]) - (4*Sqrt[3*x - 4*x^2])/(9*x)}
{1/(3*x - 4*x^2)^(5/2), x, 4, 2/(9*(3*x - 4*x^2)^(3/2)) + 4/(9*x*Sqrt[3*x - 4*x^2]) - (16*Sqrt[3*x - 4*x^2])/(81*x^2) - (128*Sqrt[3*x - 4*x^2])/(243*x)}
{1/(3*x - 4*x^2)^(7/2), x, 6, 2/(15*(3*x - 4*x^2)^(5/2)) + 4/(27*x*(3*x - 4*x^2)^(3/2)) + 32/(81*x^2*Sqrt[3*x - 4*x^2]) - (64*Sqrt[3*x - 4*x^2])/(405*x^3) - (1024*Sqrt[3*x - 4*x^2])/(3645*x^2) - (8192*Sqrt[3*x - 4*x^2])/(10935*x)}


{1/Sqrt[b*x - b^2*x^2], x, 1, -(ArcSin[1 - 2*b*x]/b)}
{1/Sqrt[b*x + b^2*x^2], x, 1, (2*ArcTanh[(b*x)/Sqrt[b*x + b^2*x^2]])/b}


{1/Sqrt[6*x - x^2], x, 1, -ArcSin[1 - x/3]}
{1/Sqrt[4*x + x^2], x, 1, 2*ArcTanh[x/Sqrt[4*x + x^2]]}
{1/Sqrt[-2*x + x^2], x, 1, 2*ArcTanh[x/Sqrt[-2*x + x^2]]}

{x/Sqrt[4*x - x^2], x, 2, -Sqrt[4*x - x^2] - 2*ArcSin[1 - x/2]}
{x/Sqrt[-4*x + x^2], x, 2, Sqrt[-4*x + x^2] + 4*ArcTanh[x/Sqrt[-4*x + x^2]]}
{x^2/Sqrt[2*x - x^2], x, 3, (-(3/2))*Sqrt[2*x - x^2] - (1/2)*x*Sqrt[2*x - x^2] - (3/2)*ArcSin[1 - x]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (b x+c x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(7/2)*(b*x + c*x^2), x, 3, (2/11)*b*x^(11/2) + (2/13)*c*x^(13/2)}
{x^(5/2)*(b*x + c*x^2), x, 3, (2/9)*b*x^(9/2) + (2/11)*c*x^(11/2)}
{x^(3/2)*(b*x + c*x^2), x, 3, (2/7)*b*x^(7/2) + (2/9)*c*x^(9/2)}
{x^(1/2)*(b*x + c*x^2), x, 3, (2/5)*b*x^(5/2) + (2/7)*c*x^(7/2)}
{(b*x + c*x^2)/x^(1/2), x, 3, (2/3)*b*x^(3/2) + (2/5)*c*x^(5/2)}
{(b*x + c*x^2)/x^(3/2), x, 3, 2*b*Sqrt[x] + (2/3)*c*x^(3/2)}
{(b*x + c*x^2)/x^(5/2), x, 3, -((2*b)/Sqrt[x]) + 2*c*Sqrt[x]}
{(b*x + c*x^2)/x^(7/2), x, 3, -((2*b)/(3*x^(3/2))) - (2*c)/Sqrt[x]}


{x^(7/2)*(b*x + c*x^2)^2, x, 3, (2/13)*b^2*x^(13/2) + (4/15)*b*c*x^(15/2) + (2/17)*c^2*x^(17/2)}
{x^(5/2)*(b*x + c*x^2)^2, x, 3, (2/11)*b^2*x^(11/2) + (4/13)*b*c*x^(13/2) + (2/15)*c^2*x^(15/2)}
{x^(3/2)*(b*x + c*x^2)^2, x, 3, (2/9)*b^2*x^(9/2) + (4/11)*b*c*x^(11/2) + (2/13)*c^2*x^(13/2)}
{x^(1/2)*(b*x + c*x^2)^2, x, 3, (2/7)*b^2*x^(7/2) + (4/9)*b*c*x^(9/2) + (2/11)*c^2*x^(11/2)}
{(b*x + c*x^2)^2/x^(1/2), x, 3, (2/5)*b^2*x^(5/2) + (4/7)*b*c*x^(7/2) + (2/9)*c^2*x^(9/2)}
{(b*x + c*x^2)^2/x^(3/2), x, 3, (2/3)*b^2*x^(3/2) + (4/5)*b*c*x^(5/2) + (2/7)*c^2*x^(7/2)}
{(b*x + c*x^2)^2/x^(5/2), x, 3, 2*b^2*Sqrt[x] + (4/3)*b*c*x^(3/2) + (2/5)*c^2*x^(5/2)}
{(b*x + c*x^2)^2/x^(7/2), x, 3, -((2*b^2)/Sqrt[x]) + 4*b*c*Sqrt[x] + (2/3)*c^2*x^(3/2)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(7/2)/(b*x + c*x^2), x, 5, (2*b^2*Sqrt[x])/c^3 - (2*b*x^(3/2))/(3*c^2) + (2*x^(5/2))/(5*c) - (2*b^(5/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/c^(7/2)}
{x^(5/2)/(b*x + c*x^2), x, 4, -((2*b*Sqrt[x])/c^2) + (2*x^(3/2))/(3*c) + (2*b^(3/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/c^(5/2)}
{x^(3/2)/(b*x + c*x^2), x, 3, (2*Sqrt[x])/c - (2*Sqrt[b]*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/c^(3/2)}
{x^(1/2)/(b*x + c*x^2), x, 2, (2*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/(Sqrt[b]*Sqrt[c])}
{1/(x^(1/2)*(b*x + c*x^2)), x, 3, -(2/(b*Sqrt[x])) - (2*Sqrt[c]*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(3/2)}
{1/(x^(3/2)*(b*x + c*x^2)), x, 4, -(2/(3*b*x^(3/2))) + (2*c)/(b^2*Sqrt[x]) + (2*c^(3/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(5/2)}
{1/(x^(5/2)*(b*x + c*x^2)), x, 5, -(2/(5*b*x^(5/2))) + (2*c)/(3*b^2*x^(3/2)) - (2*c^2)/(b^3*Sqrt[x]) - (2*c^(5/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(7/2)}


{x^(11/2)/(b*x + c*x^2)^2, x, 6, (7*b^2*Sqrt[x])/c^4 - (7*b*x^(3/2))/(3*c^3) + (7*x^(5/2))/(5*c^2) - x^(7/2)/(c*(b + c*x)) - (7*b^(5/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/c^(9/2)}
{x^(9/2)/(b*x + c*x^2)^2, x, 5, -((5*b*Sqrt[x])/c^3) + (5*x^(3/2))/(3*c^2) - x^(5/2)/(c*(b + c*x)) + (5*b^(3/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/c^(7/2)}
{x^(7/2)/(b*x + c*x^2)^2, x, 4, (3*Sqrt[x])/c^2 - x^(3/2)/(c*(b + c*x)) - (3*Sqrt[b]*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/c^(5/2)}
{x^(5/2)/(b*x + c*x^2)^2, x, 3, -(Sqrt[x]/(c*(b + c*x))) + ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]]/(Sqrt[b]*c^(3/2))}
{x^(3/2)/(b*x + c*x^2)^2, x, 3, Sqrt[x]/(b*(b + c*x)) + ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]]/(b^(3/2)*Sqrt[c])}
{x^(1/2)/(b*x + c*x^2)^2, x, 4, -(3/(b^2*Sqrt[x])) + 1/(b*Sqrt[x]*(b + c*x)) - (3*Sqrt[c]*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(5/2)}
{1/(x^(1/2)*(b*x + c*x^2)^2), x, 5, -(5/(3*b^2*x^(3/2))) + (5*c)/(b^3*Sqrt[x]) + 1/(b*x^(3/2)*(b + c*x)) + (5*c^(3/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(7/2)}
{1/(x^(3/2)*(b*x + c*x^2)^2), x, 6, -(7/(5*b^2*x^(5/2))) + (7*c)/(3*b^3*x^(3/2)) - (7*c^2)/(b^4*Sqrt[x]) + 1/(b*x^(5/2)*(b + c*x)) - (7*c^(5/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(9/2)}
{1/(x^(5/2)*(b*x + c*x^2)^2), x, 7, -(9/(7*b^2*x^(7/2))) + (9*c)/(5*b^3*x^(5/2)) - (3*c^2)/(b^4*x^(3/2)) + (9*c^3)/(b^5*Sqrt[x]) + 1/(b*x^(7/2)*(b + c*x)) + (9*c^(7/2)*ArcTan[(Sqrt[c]*Sqrt[x])/Sqrt[b]])/b^(11/2)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (b x+c x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(7/2)*(b*x + c*x^2)^(1/2), x, 5, (256*b^4*(b*x + c*x^2)^(3/2))/(3465*c^5*x^(3/2)) - (128*b^3*(b*x + c*x^2)^(3/2))/(1155*c^4*Sqrt[x]) + (32*b^2*Sqrt[x]*(b*x + c*x^2)^(3/2))/(231*c^3) - (16*b*x^(3/2)*(b*x + c*x^2)^(3/2))/(99*c^2) + (2*x^(5/2)*(b*x + c*x^2)^(3/2))/(11*c)}
{x^(5/2)*(b*x + c*x^2)^(1/2), x, 4, -((32*b^3*(b*x + c*x^2)^(3/2))/(315*c^4*x^(3/2))) + (16*b^2*(b*x + c*x^2)^(3/2))/(105*c^3*Sqrt[x]) - (4*b*Sqrt[x]*(b*x + c*x^2)^(3/2))/(21*c^2) + (2*x^(3/2)*(b*x + c*x^2)^(3/2))/(9*c)}
{x^(3/2)*(b*x + c*x^2)^(1/2), x, 3, (16*b^2*(b*x + c*x^2)^(3/2))/(105*c^3*x^(3/2)) - (8*b*(b*x + c*x^2)^(3/2))/(35*c^2*Sqrt[x]) + (2*Sqrt[x]*(b*x + c*x^2)^(3/2))/(7*c)}
{x^(1/2)*(b*x + c*x^2)^(1/2), x, 2, -((4*b*(b*x + c*x^2)^(3/2))/(15*c^2*x^(3/2))) + (2*(b*x + c*x^2)^(3/2))/(5*c*Sqrt[x])}
{(b*x + c*x^2)^(1/2)/x^(1/2), x, 1, (2*(b*x + c*x^2)^(3/2))/(3*c*x^(3/2))}
{(b*x + c*x^2)^(1/2)/x^(3/2), x, 2, (2*Sqrt[b*x + c*x^2])/Sqrt[x] - 2*Sqrt[b]*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]]}
{(b*x + c*x^2)^(1/2)/x^(5/2), x, 2, -(Sqrt[b*x + c*x^2]/x^(3/2)) - (c*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/Sqrt[b]}
{(b*x + c*x^2)^(1/2)/x^(7/2), x, 3, -(Sqrt[b*x + c*x^2]/(2*x^(5/2))) - (c*Sqrt[b*x + c*x^2])/(4*b*x^(3/2)) + (c^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(4*b^(3/2))}
{(b*x + c*x^2)^(1/2)/x^(9/2), x, 4, -(Sqrt[b*x + c*x^2]/(3*x^(7/2))) - (c*Sqrt[b*x + c*x^2])/(12*b*x^(5/2)) + (c^2*Sqrt[b*x + c*x^2])/(8*b^2*x^(3/2)) - (c^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(8*b^(5/2))}
{(b*x + c*x^2)^(1/2)/x^(11/2), x, 5, -(Sqrt[b*x + c*x^2]/(4*x^(9/2))) - (c*Sqrt[b*x + c*x^2])/(24*b*x^(7/2)) + (5*c^2*Sqrt[b*x + c*x^2])/(96*b^2*x^(5/2)) - (5*c^3*Sqrt[b*x + c*x^2])/(64*b^3*x^(3/2)) + (5*c^4*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(64*b^(7/2))}


{x^(7/2)*(b*x + c*x^2)^(3/2), x, 6, -((512*b^5*(b*x + c*x^2)^(5/2))/(45045*c^6*x^(5/2))) + (256*b^4*(b*x + c*x^2)^(5/2))/(9009*c^5*x^(3/2)) - (64*b^3*(b*x + c*x^2)^(5/2))/(1287*c^4*Sqrt[x]) + (32*b^2*Sqrt[x]*(b*x + c*x^2)^(5/2))/(429*c^3) - (4*b*x^(3/2)*(b*x + c*x^2)^(5/2))/(39*c^2) + (2*x^(5/2)*(b*x + c*x^2)^(5/2))/(15*c)}
{x^(5/2)*(b*x + c*x^2)^(3/2), x, 5, (256*b^4*(b*x + c*x^2)^(5/2))/(15015*c^5*x^(5/2)) - (128*b^3*(b*x + c*x^2)^(5/2))/(3003*c^4*x^(3/2)) + (32*b^2*(b*x + c*x^2)^(5/2))/(429*c^3*Sqrt[x]) - (16*b*Sqrt[x]*(b*x + c*x^2)^(5/2))/(143*c^2) + (2*x^(3/2)*(b*x + c*x^2)^(5/2))/(13*c)}
{x^(3/2)*(b*x + c*x^2)^(3/2), x, 4, -((32*b^3*(b*x + c*x^2)^(5/2))/(1155*c^4*x^(5/2))) + (16*b^2*(b*x + c*x^2)^(5/2))/(231*c^3*x^(3/2)) - (4*b*(b*x + c*x^2)^(5/2))/(33*c^2*Sqrt[x]) + (2*Sqrt[x]*(b*x + c*x^2)^(5/2))/(11*c)}
{x^(1/2)*(b*x + c*x^2)^(3/2), x, 3, (16*b^2*(b*x + c*x^2)^(5/2))/(315*c^3*x^(5/2)) - (8*b*(b*x + c*x^2)^(5/2))/(63*c^2*x^(3/2)) + (2*(b*x + c*x^2)^(5/2))/(9*c*Sqrt[x])}
{(b*x + c*x^2)^(3/2)/x^(1/2), x, 2, -((4*b*(b*x + c*x^2)^(5/2))/(35*c^2*x^(5/2))) + (2*(b*x + c*x^2)^(5/2))/(7*c*x^(3/2))}
{(b*x + c*x^2)^(3/2)/x^(3/2), x, 1, (2*(b*x + c*x^2)^(5/2))/(5*c*x^(5/2))}
{(b*x + c*x^2)^(3/2)/x^(5/2), x, 3, (2*b*Sqrt[b*x + c*x^2])/Sqrt[x] + (2*(b*x + c*x^2)^(3/2))/(3*x^(3/2)) - 2*b^(3/2)*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]]}
{(b*x + c*x^2)^(3/2)/x^(7/2), x, 3, (3*c*Sqrt[b*x + c*x^2])/Sqrt[x] - (b*x + c*x^2)^(3/2)/x^(5/2) - 3*Sqrt[b]*c*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]]}
{(b*x + c*x^2)^(3/2)/x^(9/2), x, 3, -((3*c*Sqrt[b*x + c*x^2])/(4*x^(3/2))) - (b*x + c*x^2)^(3/2)/(2*x^(7/2)) - (3*c^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(4*Sqrt[b])}
{(b*x + c*x^2)^(3/2)/x^(11/2), x, 4, -((c*Sqrt[b*x + c*x^2])/(4*x^(5/2))) - (c^2*Sqrt[b*x + c*x^2])/(8*b*x^(3/2)) - (b*x + c*x^2)^(3/2)/(3*x^(9/2)) + (c^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(8*b^(3/2))}
{(b*x + c*x^2)^(3/2)/x^(13/2), x, 5, -((c*Sqrt[b*x + c*x^2])/(8*x^(7/2))) - (c^2*Sqrt[b*x + c*x^2])/(32*b*x^(5/2)) + (3*c^3*Sqrt[b*x + c*x^2])/(64*b^2*x^(3/2)) - (b*x + c*x^2)^(3/2)/(4*x^(11/2)) - (3*c^4*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(64*b^(5/2))}
{(b*x + c*x^2)^(3/2)/x^(15/2), x, 6, -((3*c*Sqrt[b*x + c*x^2])/(40*x^(9/2))) - (c^2*Sqrt[b*x + c*x^2])/(80*b*x^(7/2)) + (c^3*Sqrt[b*x + c*x^2])/(64*b^2*x^(5/2)) - (3*c^4*Sqrt[b*x + c*x^2])/(128*b^3*x^(3/2)) - (b*x + c*x^2)^(3/2)/(5*x^(13/2)) + (3*c^5*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(128*b^(7/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(7/2)/(b*x + c*x^2)^(1/2), x, 4, -((32*b^3*Sqrt[b*x + c*x^2])/(35*c^4*Sqrt[x])) + (16*b^2*Sqrt[x]*Sqrt[b*x + c*x^2])/(35*c^3) - (12*b*x^(3/2)*Sqrt[b*x + c*x^2])/(35*c^2) + (2*x^(5/2)*Sqrt[b*x + c*x^2])/(7*c)}
{x^(5/2)/(b*x + c*x^2)^(1/2), x, 3, (16*b^2*Sqrt[b*x + c*x^2])/(15*c^3*Sqrt[x]) - (8*b*Sqrt[x]*Sqrt[b*x + c*x^2])/(15*c^2) + (2*x^(3/2)*Sqrt[b*x + c*x^2])/(5*c)}
{x^(3/2)/(b*x + c*x^2)^(1/2), x, 2, -((4*b*Sqrt[b*x + c*x^2])/(3*c^2*Sqrt[x])) + (2*Sqrt[x]*Sqrt[b*x + c*x^2])/(3*c)}
{x^(1/2)/(b*x + c*x^2)^(1/2), x, 1, (2*Sqrt[b*x + c*x^2])/(c*Sqrt[x])}
{1/(x^(1/2)*(b*x + c*x^2)^(1/2)), x, 1, -((2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/Sqrt[b])}
{1/(x^(3/2)*(b*x + c*x^2)^(1/2)), x, 2, -(Sqrt[b*x + c*x^2]/(b*x^(3/2))) + (c*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/b^(3/2)}
{1/(x^(5/2)*(b*x + c*x^2)^(1/2)), x, 3, -(Sqrt[b*x + c*x^2]/(2*b*x^(5/2))) + (3*c*Sqrt[b*x + c*x^2])/(4*b^2*x^(3/2)) - (3*c^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(4*b^(5/2))}
{1/(x^(7/2)*(b*x + c*x^2)^(1/2)), x, 4, -(Sqrt[b*x + c*x^2]/(3*b*x^(7/2))) + (5*c*Sqrt[b*x + c*x^2])/(12*b^2*x^(5/2)) - (5*c^2*Sqrt[b*x + c*x^2])/(8*b^3*x^(3/2)) + (5*c^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(8*b^(7/2))}


{x^(13/2)/(b*x + c*x^2)^(3/2), x, 6, -((2*x^(11/2))/(c*Sqrt[b*x + c*x^2])) + (512*b^4*Sqrt[b*x + c*x^2])/(63*c^6*Sqrt[x]) - (256*b^3*Sqrt[x]*Sqrt[b*x + c*x^2])/(63*c^5) + (64*b^2*x^(3/2)*Sqrt[b*x + c*x^2])/(21*c^4) - (160*b*x^(5/2)*Sqrt[b*x + c*x^2])/(63*c^3) + (20*x^(7/2)*Sqrt[b*x + c*x^2])/(9*c^2)}
{x^(11/2)/(b*x + c*x^2)^(3/2), x, 5, -((2*x^(9/2))/(c*Sqrt[b*x + c*x^2])) - (256*b^3*Sqrt[b*x + c*x^2])/(35*c^5*Sqrt[x]) + (128*b^2*Sqrt[x]*Sqrt[b*x + c*x^2])/(35*c^4) - (96*b*x^(3/2)*Sqrt[b*x + c*x^2])/(35*c^3) + (16*x^(5/2)*Sqrt[b*x + c*x^2])/(7*c^2)}
{x^(9/2)/(b*x + c*x^2)^(3/2), x, 4, -((2*x^(7/2))/(c*Sqrt[b*x + c*x^2])) + (32*b^2*Sqrt[b*x + c*x^2])/(5*c^4*Sqrt[x]) - (16*b*Sqrt[x]*Sqrt[b*x + c*x^2])/(5*c^3) + (12*x^(3/2)*Sqrt[b*x + c*x^2])/(5*c^2)}
{x^(7/2)/(b*x + c*x^2)^(3/2), x, 3, -((2*x^(5/2))/(c*Sqrt[b*x + c*x^2])) - (16*b*Sqrt[b*x + c*x^2])/(3*c^3*Sqrt[x]) + (8*Sqrt[x]*Sqrt[b*x + c*x^2])/(3*c^2)}
{x^(5/2)/(b*x + c*x^2)^(3/2), x, 2, -((2*x^(3/2))/(c*Sqrt[b*x + c*x^2])) + (4*Sqrt[b*x + c*x^2])/(c^2*Sqrt[x])}
{x^(3/2)/(b*x + c*x^2)^(3/2), x, 1, -((2*Sqrt[x])/(c*Sqrt[b*x + c*x^2]))}
{x^(1/2)/(b*x + c*x^2)^(3/2), x, 2, (2*Sqrt[x])/(b*Sqrt[b*x + c*x^2]) - (2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/b^(3/2)}
{1/(x^(1/2)*(b*x + c*x^2)^(3/2)), x, 3, 2/(b*Sqrt[x]*Sqrt[b*x + c*x^2]) - (3*Sqrt[b*x + c*x^2])/(b^2*x^(3/2)) + (3*c*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/b^(5/2)}
{1/(x^(3/2)*(b*x + c*x^2)^(3/2)), x, 4, 2/(b*x^(3/2)*Sqrt[b*x + c*x^2]) - (5*Sqrt[b*x + c*x^2])/(2*b^2*x^(5/2)) + (15*c*Sqrt[b*x + c*x^2])/(4*b^3*x^(3/2)) - (15*c^2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(4*b^(7/2))}
{1/(x^(5/2)*(b*x + c*x^2)^(3/2)), x, 5, 2/(b*x^(5/2)*Sqrt[b*x + c*x^2]) - (7*Sqrt[b*x + c*x^2])/(3*b^2*x^(7/2)) + (35*c*Sqrt[b*x + c*x^2])/(12*b^3*x^(5/2)) - (35*c^2*Sqrt[b*x + c*x^2])/(8*b^4*x^(3/2)) + (35*c^3*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[b*x + c*x^2]])/(8*b^(9/2))}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x+b x^3)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x+b x^3)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^2*(a*x + b*x^3), x, 3, (a*x^4)/4 + (b*x^6)/6}
{x*(a*x + b*x^3), x, 3, (a*x^3)/3 + (b*x^5)/5}
{a*x + b*x^3, x, 1, (a*x^2)/2 + (b*x^4)/4}
{(a*x + b*x^3)/x, x, 2, a*x + (b*x^3)/3}
{(a*x + b*x^3)/x^2, x, 3, (b*x^2)/2 + a*Log[x]}


{x^2*(a*x + b*x^3)^2, x, 3, (a^2*x^5)/5 + (2*a*b*x^7)/7 + (b^2*x^9)/9}
{x*(a*x + b*x^3)^2, x, 4, (a^2*x^4)/4 + (a*b*x^6)/3 + (b^2*x^8)/8}
{(a*x + b*x^3)^2, x, 3, (a^2*x^3)/3 + (2*a*b*x^5)/5 + (b^2*x^7)/7}
{(a*x + b*x^3)^2/x, x, 2, (a + b*x^2)^3/(6*b)}
{(a*x + b*x^3)^2/x^2, x, 3, a^2*x + (2*a*b*x^3)/3 + (b^2*x^5)/5}


{(-4*x + 3*x^3)^6, x, 3, (4096*x^7)/7 - 2048*x^9 + (34560*x^11)/11 - (34560*x^13)/13 + 1296*x^15 - (5832*x^17)/17 + (729*x^19)/19}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/(a*x + b*x^3), x, 3, x^2/(2*b) - (a*Log[a + b*x^2])/(2*b^2)}
{x^3/(a*x + b*x^3), x, 3, x/b - (Sqrt[a]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(3/2)}
{x^2/(a*x + b*x^3), x, 2, Log[a + b*x^2]/(2*b)}
{x^1/(a*x + b*x^3), x, 2, ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(Sqrt[a]*Sqrt[b])}
{x^0/(a*x + b*x^3), x, 2, Log[x]/a - Log[a + b*x^2]/(2*a)}
{1/(x^1*(a*x + b*x^3)), x, 3, -(1/(a*x)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(3/2)}
{1/(x^2*(a*x + b*x^3)), x, 3, -(1/(2*a*x^2)) - (b*Log[x])/a^2 + (b*Log[a + b*x^2])/(2*a^2)}
{1/(x^3*(a*x + b*x^3)), x, 4, -(1/(3*a*x^3)) + b/(a^2*x) + (b^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(5/2)}
{1/(x^4*(a*x + b*x^3)), x, 4, -(1/(4*a*x^4)) + b/(2*a^2*x^2) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x^2])/(2*a^3)}


{x^2/(a*x + b*x^3)^2, x, 3, x/(2*a*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(2*a^(3/2)*Sqrt[b])}
{x^1/(a*x + b*x^3)^2, x, 3, 1/(2*a*(a + b*x^2)) + Log[x]/a^2 - Log[a + b*x^2]/(2*a^2)}
{x^0/(a*x + b*x^3)^2, x, 4, -3/(2*a^2*x) + 1/(2*a*x*(a + b*x^2)) - (3*Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(5/2))}
{1/(x^1*(a*x + b*x^3)^2), x, 4, -(1/(a^2*x^2)) + 1/(2*a*x^2*(a + b*x^2)) - (2*b*Log[x])/a^3 + (b*Log[a + b*x^2])/a^3}
{1/(x^2*(a*x + b*x^3)^2), x, 5, -5/(6*a^2*x^3) + (5*b)/(2*a^3*x) + 1/(2*a*x^3*(a + b*x^2)) + (5*b^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(7/2))}


(* In some of the following examples gcd cancellation should occur without also partial fraction 
	expansion, since that will result in unnecessary expansion. *)
{x^5/(x - x^3), x, 4, -x - x^3/3 + ArcTanh[x]}
{x^4/(x - x^3), x, 3, -(x^2/2) - (1/2)*Log[1 - x^2]}
{x^3/(x - x^3), x, 3, -x + ArcTanh[x]}
{x^2/(x - x^3), x, 2, (-(1/2))*Log[1 - x^2]}
{x/(x - x^3), x, 2, ArcTanh[x]}
{1/(x - x^3), x, 2, -ArcTanh[1 - 2*x^2]}
{1/(x*(x - x^3)), x, 3, -(1/x) + ArcTanh[x]}
{1/(x^2*(x - x^3)), x, 3, -(1/(2*x^2)) - ArcTanh[1 - 2*x^2]}
{1/(x^3*(x - x^3)), x, 4, -(1/(3*x^3)) - 1/x + ArcTanh[x]}
{1/(x^4*(x - x^3)), x, 4, -(1/(4*x^4)) - 1/(2*x^2) - ArcTanh[1 - 2*x^2]}


{1/(x + b*x^3), x, 2, -ArcTanh[1 + 2*b*x^2]}
{1/(-x + b*x^3), x, 2, ArcTanh[1 - 2*b*x^2]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x+b x^3)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*Sqrt[a*x + b*x^3], x, 7, -((20*a^2*Sqrt[a*x + b*x^3])/(231*b^2)) + (4*a*x^2*Sqrt[a*x + b*x^3])/(77*b) + (2/11)*x^4*Sqrt[a*x + b*x^3] + (20*a^(13/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(231*(-b)^(9/4)*Sqrt[a*x + b*x^3])}
{x^2*Sqrt[a*x + b*x^3], x, 6, (4*a*x*Sqrt[a*x + b*x^3])/(45*b) + (2/9)*x^3*Sqrt[a*x + b*x^3] + (4*a^(11/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(15*(-b)^(7/4)*Sqrt[a*x + b*x^3]) - (4*a^(11/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(15*(-b)^(7/4)*Sqrt[a*x + b*x^3])}
{x*Sqrt[a*x + b*x^3], x, 6, (4*a*Sqrt[a*x + b*x^3])/(21*b) + (2/7)*x^2*Sqrt[a*x + b*x^3] + (4*a^(9/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(21*(-b)^(5/4)*Sqrt[a*x + b*x^3])}
{Sqrt[a*x + b*x^3], x, 5, (2/5)*x*Sqrt[a*x + b*x^3] + (4*a^(7/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*(-b)^(3/4)*Sqrt[a*x + b*x^3]) - (4*a^(7/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*(-b)^(3/4)*Sqrt[a*x + b*x^3])}
{Sqrt[a*x + b*x^3]/x, x, 5, (2/3)*Sqrt[a*x + b*x^3] + (4*a^(5/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(3*(-b)^(1/4)*Sqrt[a*x + b*x^3])}
{Sqrt[a*x + b*x^3]/x^2, x, 5, -((2*Sqrt[a*x + b*x^3])/x) - (4*a^(3/4)*(-b)^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/Sqrt[a*x + b*x^3] + (4*a^(3/4)*(-b)^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/Sqrt[a*x + b*x^3]}


{x^2*(a*x + b*x^3)^(3/2), x, 8, -((8*a^3*Sqrt[a*x + b*x^3])/(231*b^2)) + (8*a^2*x^2*Sqrt[a*x + b*x^3])/(385*b) + (4/55)*a*x^4*Sqrt[a*x + b*x^3] + (2/15)*x^3*(a*x + b*x^3)^(3/2) + (8*a^(17/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(231*(-b)^(9/4)*Sqrt[a*x + b*x^3])}
{x*(a*x + b*x^3)^(3/2), x, 7, (8*a^2*x*Sqrt[a*x + b*x^3])/(195*b) + (4/39)*a*x^3*Sqrt[a*x + b*x^3] + (2/13)*x^2*(a*x + b*x^3)^(3/2) + (8*a^(15/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(65*(-b)^(7/4)*Sqrt[a*x + b*x^3]) - (8*a^(15/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(65*(-b)^(7/4)*Sqrt[a*x + b*x^3])}
{(a*x + b*x^3)^(3/2), x, 7, (8*a^2*Sqrt[a*x + b*x^3])/(77*b) + (12/77)*a*x^2*Sqrt[a*x + b*x^3] + (2/11)*x*(a*x + b*x^3)^(3/2) + (8*a^(13/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(77*(-b)^(5/4)*Sqrt[a*x + b*x^3])}
{(a*x + b*x^3)^(3/2)/x, x, 6, (4/15)*a*x*Sqrt[a*x + b*x^3] + (2/9)*(a*x + b*x^3)^(3/2) + (8*a^(11/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(15*(-b)^(3/4)*Sqrt[a*x + b*x^3]) - (8*a^(11/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(15*(-b)^(3/4)*Sqrt[a*x + b*x^3])}
{(a*x + b*x^3)^(3/2)/x^2, x, 6, (4/7)*a*Sqrt[a*x + b*x^3] + (2*(a*x + b*x^3)^(3/2))/(7*x) + (8*a^(9/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(7*(-b)^(1/4)*Sqrt[a*x + b*x^3])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/Sqrt[a*x + b*x^3], x, 6, -((10*a*Sqrt[a*x + b*x^3])/(21*b^2)) + (2*x^2*Sqrt[a*x + b*x^3])/(7*b) + (10*a^(9/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(21*(-b)^(9/4)*Sqrt[a*x + b*x^3])}
{x^3/Sqrt[a*x + b*x^3], x, 5, (2*x*Sqrt[a*x + b*x^3])/(5*b) + (6*a^(7/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*(-b)^(7/4)*Sqrt[a*x + b*x^3]) - (6*a^(7/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*(-b)^(7/4)*Sqrt[a*x + b*x^3])}
{x^2/Sqrt[a*x + b*x^3], x, 5, (2*Sqrt[a*x + b*x^3])/(3*b) + (2*a^(5/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(3*(-b)^(5/4)*Sqrt[a*x + b*x^3])}
{x/Sqrt[a*x + b*x^3], x, 4, (2*a^(3/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/((-b)^(3/4)*Sqrt[a*x + b*x^3]) - (2*a^(3/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/((-b)^(3/4)*Sqrt[a*x + b*x^3])}
{1/Sqrt[a*x + b*x^3], x, 4, (2*a^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/((-b)^(1/4)*Sqrt[a*x + b*x^3])}
{1/(x*Sqrt[a*x + b*x^3]), x, 5, -((2*Sqrt[a*x + b*x^3])/(a*x)) - (2*(-b)^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(1/4)*Sqrt[a*x + b*x^3]) + (2*(-b)^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(1/4)*Sqrt[a*x + b*x^3])}
{1/(x^2*Sqrt[a*x + b*x^3]), x, 5, -((2*Sqrt[a*x + b*x^3])/(3*a*x^2)) + (2*(-b)^(3/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(3*a^(3/4)*Sqrt[a*x + b*x^3])}
{1/(x^3*Sqrt[a*x + b*x^3]), x, 6, -((2*Sqrt[a*x + b*x^3])/(5*a*x^3)) + (6*b*Sqrt[a*x + b*x^3])/(5*a^2*x) - (6*(-b)^(5/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*a^(5/4)*Sqrt[a*x + b*x^3]) + (6*(-b)^(5/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*a^(5/4)*Sqrt[a*x + b*x^3])}


{x^2/(a*x + b*x^3)^(3/2), x, 5, x^2/(a*Sqrt[a*x + b*x^3]) - (Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(1/4)*(-b)^(3/4)*Sqrt[a*x + b*x^3]) + (Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(1/4)*(-b)^(3/4)*Sqrt[a*x + b*x^3])}
{x/(a*x + b*x^3)^(3/2), x, 5, x/(a*Sqrt[a*x + b*x^3]) + (Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(3/4)*(-b)^(1/4)*Sqrt[a*x + b*x^3])}
{1/(a*x + b*x^3)^(3/2), x, 6, 1/(a*Sqrt[a*x + b*x^3]) - (3*Sqrt[a*x + b*x^3])/(a^2*x) - (3*(-b)^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(5/4)*Sqrt[a*x + b*x^3]) + (3*(-b)^(1/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(a^(5/4)*Sqrt[a*x + b*x^3])}
{1/(x*(a*x + b*x^3)^(3/2)), x, 6, 1/(a*x*Sqrt[a*x + b*x^3]) - (5*Sqrt[a*x + b*x^3])/(3*a^2*x^2) + (5*(-b)^(3/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(3*a^(7/4)*Sqrt[a*x + b*x^3])}
{1/(x^2*(a*x + b*x^3)^(3/2)), x, 7, 1/(a*x^2*Sqrt[a*x + b*x^3]) - (7*Sqrt[a*x + b*x^3])/(5*a^2*x^3) + (21*b*Sqrt[a*x + b*x^3])/(5*a^3*x) - (21*(-b)^(5/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticE[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*a^(9/4)*Sqrt[a*x + b*x^3]) + (21*(-b)^(5/4)*Sqrt[x]*Sqrt[(a + b*x^2)/a]*EllipticF[ArcSin[((-b)^(1/4)*Sqrt[x])/a^(1/4)], -1])/(5*a^(9/4)*Sqrt[a*x + b*x^3])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a x+b x^3)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(29/2)/(a*x + b*x^3)^(9/2), x, 6, -(x^(25/2)/(7*b*(a*x + b*x^3)^(7/2))) - (9*x^(19/2))/(35*b^2*(a*x + b*x^3)^(5/2)) - (3*x^(13/2))/(5*b^3*(a*x + b*x^3)^(3/2)) - (3*x^(7/2))/(b^4*Sqrt[a*x + b*x^3]) + (9*Sqrt[x]*Sqrt[a*x + b*x^3])/(2*b^5) - (9*a*ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x + b*x^3]])/(2*b^(11/2))}
{x^(27/2)/(a*x + b*x^3)^(9/2), x, 5, -(x^(23/2)/(7*b*(a*x + b*x^3)^(7/2))) - (8*x^(17/2))/(35*b^2*(a*x + b*x^3)^(5/2)) - (16*x^(11/2))/(35*b^3*(a*x + b*x^3)^(3/2)) - (64*x^(5/2))/(35*b^4*Sqrt[a*x + b*x^3]) + (128*Sqrt[a*x + b*x^3])/(35*b^5*Sqrt[x])}
{x^(25/2)/(a*x + b*x^3)^(9/2), x, 5, -(x^(21/2)/(7*b*(a*x + b*x^3)^(7/2))) - x^(15/2)/(5*b^2*(a*x + b*x^3)^(5/2)) - x^(9/2)/(3*b^3*(a*x + b*x^3)^(3/2)) - x^(3/2)/(b^4*Sqrt[a*x + b*x^3]) + ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x + b*x^3]]/b^(9/2)}
{x^(23/2)/(a*x + b*x^3)^(9/2), x, 4, -(x^(19/2)/(7*b*(a*x + b*x^3)^(7/2))) - (6*x^(13/2))/(35*b^2*(a*x + b*x^3)^(5/2)) - (8*x^(7/2))/(35*b^3*(a*x + b*x^3)^(3/2)) - (16*Sqrt[x])/(35*b^4*Sqrt[a*x + b*x^3])}
{x^(21/2)/(a*x + b*x^3)^(9/2), x, 1, x^(21/2)/(7*a*(a*x + b*x^3)^(7/2))}
{x^(19/2)/(a*x + b*x^3)^(9/2), x, 3, -(x^(15/2)/(7*b*(a*x + b*x^3)^(7/2))) - (4*x^(9/2))/(35*b^2*(a*x + b*x^3)^(5/2)) - (8*x^(3/2))/(105*b^3*(a*x + b*x^3)^(3/2))}
{x^(17/2)/(a*x + b*x^3)^(9/2), x, 2, x^(17/2)/(7*a*(a*x + b*x^3)^(7/2)) + (2*x^(15/2))/(35*a^2*(a*x + b*x^3)^(5/2))}
{x^(15/2)/(a*x + b*x^3)^(9/2), x, 2, -(x^(11/2)/(7*b*(a*x + b*x^3)^(7/2))) - (2*x^(5/2))/(35*b^2*(a*x + b*x^3)^(5/2))}
{x^(13/2)/(a*x + b*x^3)^(9/2), x, 3, x^(13/2)/(7*a*(a*x + b*x^3)^(7/2)) + (4*x^(11/2))/(35*a^2*(a*x + b*x^3)^(5/2)) + (8*x^(9/2))/(105*a^3*(a*x + b*x^3)^(3/2))}
{x^(11/2)/(a*x + b*x^3)^(9/2), x, 1, -(x^(7/2)/(7*b*(a*x + b*x^3)^(7/2)))}
{x^(9/2)/(a*x + b*x^3)^(9/2), x, 4, x^(9/2)/(7*a*(a*x + b*x^3)^(7/2)) + (6*x^(7/2))/(35*a^2*(a*x + b*x^3)^(5/2)) + (8*x^(5/2))/(35*a^3*(a*x + b*x^3)^(3/2)) + (16*x^(3/2))/(35*a^4*Sqrt[a*x + b*x^3])}
{x^(7/2)/(a*x + b*x^3)^(9/2), x, 5, x^(7/2)/(7*a*(a*x + b*x^3)^(7/2)) + x^(5/2)/(5*a^2*(a*x + b*x^3)^(5/2)) + x^(3/2)/(3*a^3*(a*x + b*x^3)^(3/2)) + Sqrt[x]/(a^4*Sqrt[a*x + b*x^3]) - ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[a*x + b*x^3]]/a^(9/2)}
{x^(5/2)/(a*x + b*x^3)^(9/2), x, 5, x^(5/2)/(7*a*(a*x + b*x^3)^(7/2)) + (8*x^(3/2))/(35*a^2*(a*x + b*x^3)^(5/2)) + (16*Sqrt[x])/(35*a^3*(a*x + b*x^3)^(3/2)) + 64/(35*a^4*Sqrt[x]*Sqrt[a*x + b*x^3]) - (128*Sqrt[a*x + b*x^3])/(35*a^5*x^(3/2))}
{x^(3/2)/(a*x + b*x^3)^(9/2), x, 6, x^(3/2)/(7*a*(a*x + b*x^3)^(7/2)) + (9*Sqrt[x])/(35*a^2*(a*x + b*x^3)^(5/2)) + 3/(5*a^3*Sqrt[x]*(a*x + b*x^3)^(3/2)) + 3/(a^4*x^(3/2)*Sqrt[a*x + b*x^3]) - (9*Sqrt[a*x + b*x^3])/(2*a^5*x^(5/2)) + (9*b*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[a*x + b*x^3]])/(2*a^(11/2))}
{x^(1/2)/(a*x + b*x^3)^(9/2), x, 6, Sqrt[x]/(7*a*(a*x + b*x^3)^(7/2)) + 2/(7*a^2*Sqrt[x]*(a*x + b*x^3)^(5/2)) + 16/(21*a^3*x^(3/2)*(a*x + b*x^3)^(3/2)) + 32/(7*a^4*x^(5/2)*Sqrt[a*x + b*x^3]) - (128*Sqrt[a*x + b*x^3])/(21*a^5*x^(7/2)) + (256*b*Sqrt[a*x + b*x^3])/(21*a^6*x^(3/2))}
{1/(x^(1/2)*(a*x + b*x^3)^(9/2)), x, 7, 1/(7*a*Sqrt[x]*(a*x + b*x^3)^(7/2)) + 11/(35*a^2*x^(3/2)*(a*x + b*x^3)^(5/2)) + 33/(35*a^3*x^(5/2)*(a*x + b*x^3)^(3/2)) + 33/(5*a^4*x^(7/2)*Sqrt[a*x + b*x^3]) - (33*Sqrt[a*x + b*x^3])/(4*a^5*x^(9/2)) + (99*b*Sqrt[a*x + b*x^3])/(8*a^6*x^(5/2)) - (99*b^2*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[a*x + b*x^3]])/(8*a^(13/2))}
{1/(x^(3/2)*(a*x + b*x^3)^(9/2)), x, 7, 1/(7*a*x^(3/2)*(a*x + b*x^3)^(7/2)) + 12/(35*a^2*x^(5/2)*(a*x + b*x^3)^(5/2)) + 8/(7*a^3*x^(7/2)*(a*x + b*x^3)^(3/2)) + 64/(7*a^4*x^(9/2)*Sqrt[a*x + b*x^3]) - (384*Sqrt[a*x + b*x^3])/(35*a^5*x^(11/2)) + (512*b*Sqrt[a*x + b*x^3])/(35*a^6*x^(7/2)) - (1024*b^2*Sqrt[a*x + b*x^3])/(35*a^7*x^(3/2))}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x+b x^4)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x+b x^4)^(p/2)*)


{x^4/Sqrt[a*x + b*x^4], x, 2, (x*Sqrt[a*x + b*x^4])/(3*b) - (a*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x + b*x^4]])/(3*b^(3/2))}
{x^3/Sqrt[a*x + b*x^4], x, 4, Sqrt[a*x + b*x^4]/(2*b) - (a^(2/3)*x*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(4*3^(1/4)*b*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x + b*x^4])}
{x^2/Sqrt[a*x + b*x^4], x, 3, (2*x^3*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(5*Sqrt[a*x + b*x^4])}
{x^1/Sqrt[a*x + b*x^4], x, 1, (2*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x + b*x^4]])/(3*Sqrt[b])}
{x^0/Sqrt[a*x + b*x^4], x, 3, (x*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(3^(1/4)*a^(1/3)*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x + b*x^4])}
{1/(x^1*Sqrt[a*x + b*x^4]), x, 4, -((2*Sqrt[a*x + b*x^4])/(a*x)) + (4*b*x^3*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(5*a*Sqrt[a*x + b*x^4])}
{1/(x^2*Sqrt[a*x + b*x^4]), x, 1, -((2*Sqrt[a*x + b*x^4])/(3*a*x^2))}
{1/(x^3*Sqrt[a*x + b*x^4]), x, 4, -((2*Sqrt[a*x + b*x^4])/(5*a*x^3)) - (2*b*x*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(5*3^(1/4)*a^(4/3)*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x + b*x^4])}
{1/(x^4*Sqrt[a*x + b*x^4]), x, 5, -((2*Sqrt[a*x + b*x^4])/(7*a*x^4)) + (8*b*Sqrt[a*x + b*x^4])/(7*a^2*x) - (16*b^2*x^3*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(35*a^2*Sqrt[a*x + b*x^4])}
{1/(x^5*Sqrt[a*x + b*x^4]), x, 2, -((2*Sqrt[a*x + b*x^4])/(9*a*x^5)) + (4*b*Sqrt[a*x + b*x^4])/(9*a^2*x^2)}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a x+b x^4)^(p/2)*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x+b x^5)^p*)


(* ::Subsection:: *)
(*Integrands of the form x^m (a x+b x^5)^(p/2)*)


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a x+b x^5)^(p/2)*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x+b x^(1/2))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x+b x^(1/2))^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^2/(a*x + b*x^(1/2))^(1/2), x, 7, (63*b^4*Sqrt[b*Sqrt[x] + a*x])/(64*a^5) - (21*b^3*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(32*a^4) + (21*b^2*x*Sqrt[b*Sqrt[x] + a*x])/(40*a^3) - (9*b*x^(3/2)*Sqrt[b*Sqrt[x] + a*x])/(20*a^2) + (2*x^2*Sqrt[b*Sqrt[x] + a*x])/(5*a) - (63*b^5*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(64*a^(11/2))}
{x^1/(a*x + b*x^(1/2))^(1/2), x, 5, (5*b^2*Sqrt[b*Sqrt[x] + a*x])/(4*a^3) - (5*b*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(6*a^2) + (2*x*Sqrt[b*Sqrt[x] + a*x])/(3*a) - (5*b^3*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(4*a^(7/2))}
{x^0/(a*x + b*x^(1/2))^(1/2), x, 3, (2*Sqrt[b*Sqrt[x] + a*x])/a - (2*b*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/a^(3/2)}
{1/(x^1*(a*x + b*x^(1/2))^(1/2)), x, 1, -((4*Sqrt[b*Sqrt[x] + a*x])/(b*Sqrt[x]))}
{1/(x^2*(a*x + b*x^(1/2))^(1/2)), x, 3, -((4*Sqrt[b*Sqrt[x] + a*x])/(5*b*x^(3/2))) + (16*a*Sqrt[b*Sqrt[x] + a*x])/(15*b^2*x) - (32*a^2*Sqrt[b*Sqrt[x] + a*x])/(15*b^3*Sqrt[x])}
{1/(x^3*(a*x + b*x^(1/2))^(1/2)), x, 5, -((4*Sqrt[b*Sqrt[x] + a*x])/(9*b*x^(5/2))) + (32*a*Sqrt[b*Sqrt[x] + a*x])/(63*b^2*x^2) - (64*a^2*Sqrt[b*Sqrt[x] + a*x])/(105*b^3*x^(3/2)) + (256*a^3*Sqrt[b*Sqrt[x] + a*x])/(315*b^4*x) - (512*a^4*Sqrt[b*Sqrt[x] + a*x])/(315*b^5*Sqrt[x])}
{1/(x^4*(a*x + b*x^(1/2))^(1/2)), x, 7, -((4*Sqrt[b*Sqrt[x] + a*x])/(13*b*x^(7/2))) + (48*a*Sqrt[b*Sqrt[x] + a*x])/(143*b^2*x^3) - (160*a^2*Sqrt[b*Sqrt[x] + a*x])/(429*b^3*x^(5/2)) + (1280*a^3*Sqrt[b*Sqrt[x] + a*x])/(3003*b^4*x^2) - (512*a^4*Sqrt[b*Sqrt[x] + a*x])/(1001*b^5*x^(3/2)) + (2048*a^5*Sqrt[b*Sqrt[x] + a*x])/(3003*b^6*x) - (4096*a^6*Sqrt[b*Sqrt[x] + a*x])/(3003*b^7*Sqrt[x])}


{x^3/(a*x + b*x^(1/2))^(3/2), x, 8, -((4*x^3)/(a*Sqrt[b*Sqrt[x] + a*x])) + (693*b^4*Sqrt[b*Sqrt[x] + a*x])/(64*a^6) - (231*b^3*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(32*a^5) + (231*b^2*x*Sqrt[b*Sqrt[x] + a*x])/(40*a^4) - (99*b*x^(3/2)*Sqrt[b*Sqrt[x] + a*x])/(20*a^3) + (22*x^2*Sqrt[b*Sqrt[x] + a*x])/(5*a^2) - (693*b^5*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(64*a^(13/2))}
{x^2/(a*x + b*x^(1/2))^(3/2), x, 6, -((4*x^2)/(a*Sqrt[b*Sqrt[x] + a*x])) + (35*b^2*Sqrt[b*Sqrt[x] + a*x])/(4*a^4) - (35*b*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(6*a^3) + (14*x*Sqrt[b*Sqrt[x] + a*x])/(3*a^2) - (35*b^3*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(4*a^(9/2))}
{x^1/(a*x + b*x^(1/2))^(3/2), x, 4, -((4*x)/(a*Sqrt[b*Sqrt[x] + a*x])) + (6*Sqrt[b*Sqrt[x] + a*x])/a^2 - (6*b*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/a^(5/2)}
{x^0/(a*x + b*x^(1/2))^(3/2), x, 1, (4*Sqrt[x])/(b*Sqrt[b*Sqrt[x] + a*x])}
{1/(x^1*(a*x + b*x^(1/2))^(3/2)), x, 3, 4/(b*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x]) - (16*Sqrt[b*Sqrt[x] + a*x])/(3*b^2*x) + (32*a*Sqrt[b*Sqrt[x] + a*x])/(3*b^3*Sqrt[x])}
{1/(x^2*(a*x + b*x^(1/2))^(3/2)), x, 5, 4/(b*x^(3/2)*Sqrt[b*Sqrt[x] + a*x]) - (32*Sqrt[b*Sqrt[x] + a*x])/(7*b^2*x^2) + (192*a*Sqrt[b*Sqrt[x] + a*x])/(35*b^3*x^(3/2)) - (256*a^2*Sqrt[b*Sqrt[x] + a*x])/(35*b^4*x) + (512*a^3*Sqrt[b*Sqrt[x] + a*x])/(35*b^5*Sqrt[x])}
{1/(x^3*(a*x + b*x^(1/2))^(3/2)), x, 7, 4/(b*x^(5/2)*Sqrt[b*Sqrt[x] + a*x]) - (48*Sqrt[b*Sqrt[x] + a*x])/(11*b^2*x^3) + (160*a*Sqrt[b*Sqrt[x] + a*x])/(33*b^3*x^(5/2)) - (1280*a^2*Sqrt[b*Sqrt[x] + a*x])/(231*b^4*x^2) + (512*a^3*Sqrt[b*Sqrt[x] + a*x])/(77*b^5*x^(3/2)) - (2048*a^4*Sqrt[b*Sqrt[x] + a*x])/(231*b^6*x) + (4096*a^5*Sqrt[b*Sqrt[x] + a*x])/(231*b^7*Sqrt[x])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a x+b x^(1/2))^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(5/2)/(a*x + b*x^(1/2))^(1/2), x, 8, -((231*b^5*Sqrt[b*Sqrt[x] + a*x])/(256*a^6)) + (77*b^4*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(128*a^5) - (77*b^3*x*Sqrt[b*Sqrt[x] + a*x])/(160*a^4) + (33*b^2*x^(3/2)*Sqrt[b*Sqrt[x] + a*x])/(80*a^3) - (11*b*x^2*Sqrt[b*Sqrt[x] + a*x])/(30*a^2) + (x^(5/2)*Sqrt[b*Sqrt[x] + a*x])/(3*a) + (231*b^6*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(256*a^(13/2))}
{x^(3/2)/(a*x + b*x^(1/2))^(1/2), x, 6, -((35*b^3*Sqrt[b*Sqrt[x] + a*x])/(32*a^4)) + (35*b^2*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(48*a^3) - (7*b*x*Sqrt[b*Sqrt[x] + a*x])/(12*a^2) + (x^(3/2)*Sqrt[b*Sqrt[x] + a*x])/(2*a) + (35*b^4*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(32*a^(9/2))}
{x^(1/2)/(a*x + b*x^(1/2))^(1/2), x, 4, -((3*b*Sqrt[b*Sqrt[x] + a*x])/(2*a^2)) + (Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/a + (3*b^2*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(2*a^(5/2))}
{1/(x^(1/2)*(a*x + b*x^(1/2))^(1/2)), x, 2, (4*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/Sqrt[a]}
{1/(x^(3/2)*(a*x + b*x^(1/2))^(1/2)), x, 2, -((4*Sqrt[b*Sqrt[x] + a*x])/(3*b*x)) + (8*a*Sqrt[b*Sqrt[x] + a*x])/(3*b^2*Sqrt[x])}
{1/(x^(5/2)*(a*x + b*x^(1/2))^(1/2)), x, 4, -((4*Sqrt[b*Sqrt[x] + a*x])/(7*b*x^2)) + (24*a*Sqrt[b*Sqrt[x] + a*x])/(35*b^2*x^(3/2)) - (32*a^2*Sqrt[b*Sqrt[x] + a*x])/(35*b^3*x) + (64*a^3*Sqrt[b*Sqrt[x] + a*x])/(35*b^4*Sqrt[x])}
{1/(x^(7/2)*(a*x + b*x^(1/2))^(1/2)), x, 6, -((4*Sqrt[b*Sqrt[x] + a*x])/(11*b*x^3)) + (40*a*Sqrt[b*Sqrt[x] + a*x])/(99*b^2*x^(5/2)) - (320*a^2*Sqrt[b*Sqrt[x] + a*x])/(693*b^3*x^2) + (128*a^3*Sqrt[b*Sqrt[x] + a*x])/(231*b^4*x^(3/2)) - (512*a^4*Sqrt[b*Sqrt[x] + a*x])/(693*b^5*x) + (1024*a^5*Sqrt[b*Sqrt[x] + a*x])/(693*b^6*Sqrt[x])}


{x^(5/2)/(a*x + b*x^(1/2))^(3/2), x, 7, -((4*x^(5/2))/(a*Sqrt[b*Sqrt[x] + a*x])) - (315*b^3*Sqrt[b*Sqrt[x] + a*x])/(32*a^5) + (105*b^2*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/(16*a^4) - (21*b*x*Sqrt[b*Sqrt[x] + a*x])/(4*a^3) + (9*x^(3/2)*Sqrt[b*Sqrt[x] + a*x])/(2*a^2) + (315*b^4*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(32*a^(11/2))}
{x^(3/2)/(a*x + b*x^(1/2))^(3/2), x, 5, -((4*x^(3/2))/(a*Sqrt[b*Sqrt[x] + a*x])) - (15*b*Sqrt[b*Sqrt[x] + a*x])/(2*a^3) + (5*Sqrt[x]*Sqrt[b*Sqrt[x] + a*x])/a^2 + (15*b^2*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/(2*a^(7/2))}
{x^(1/2)/(a*x + b*x^(1/2))^(3/2), x, 3, -((4*Sqrt[x])/(a*Sqrt[b*Sqrt[x] + a*x])) + (4*ArcTanh[(Sqrt[a]*Sqrt[x])/Sqrt[b*Sqrt[x] + a*x]])/a^(3/2)}
{1/(x^(1/2)*(a*x + b*x^(1/2))^(3/2)), x, 2, 4/(b*Sqrt[b*Sqrt[x] + a*x]) - (8*Sqrt[b*Sqrt[x] + a*x])/(b^2*Sqrt[x])}
{1/(x^(3/2)*(a*x + b*x^(1/2))^(3/2)), x, 4, 4/(b*x*Sqrt[b*Sqrt[x] + a*x]) - (24*Sqrt[b*Sqrt[x] + a*x])/(5*b^2*x^(3/2)) + (32*a*Sqrt[b*Sqrt[x] + a*x])/(5*b^3*x) - (64*a^2*Sqrt[b*Sqrt[x] + a*x])/(5*b^4*Sqrt[x])}
{1/(x^(5/2)*(a*x + b*x^(1/2))^(3/2)), x, 6, 4/(b*x^2*Sqrt[b*Sqrt[x] + a*x]) - (40*Sqrt[b*Sqrt[x] + a*x])/(9*b^2*x^(5/2)) + (320*a*Sqrt[b*Sqrt[x] + a*x])/(63*b^3*x^2) - (128*a^2*Sqrt[b*Sqrt[x] + a*x])/(21*b^4*x^(3/2)) + (512*a^3*Sqrt[b*Sqrt[x] + a*x])/(63*b^5*x) - (1024*a^4*Sqrt[b*Sqrt[x] + a*x])/(63*b^6*Sqrt[x])}
{1/(x^(7/2)*(a*x + b*x^(1/2))^(3/2)), x, 8, 4/(b*x^3*Sqrt[b*Sqrt[x] + a*x]) - (56*Sqrt[b*Sqrt[x] + a*x])/(13*b^2*x^(7/2)) + (672*a*Sqrt[b*Sqrt[x] + a*x])/(143*b^3*x^3) - (2240*a^2*Sqrt[b*Sqrt[x] + a*x])/(429*b^4*x^(5/2)) + (2560*a^3*Sqrt[b*Sqrt[x] + a*x])/(429*b^5*x^2) - (1024*a^4*Sqrt[b*Sqrt[x] + a*x])/(143*b^6*x^(3/2)) + (4096*a^5*Sqrt[b*Sqrt[x] + a*x])/(429*b^7*x) - (8192*a^6*Sqrt[b*Sqrt[x] + a*x])/(429*b^8*Sqrt[x])}


(* ::Title:: *)
(*Integration problems of the form x^m (a x^2+b x^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^3)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^3)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^2*(a*x^2 + b*x^3), x, 3, (a*x^5)/5 + (b*x^6)/6}
{x*(a*x^2 + b*x^3), x, 3, (a*x^4)/4 + (b*x^5)/5}
{a*x^2 + b*x^3, x, 1, (a*x^3)/3 + (b*x^4)/4}
{(a*x^2 + b*x^3)/x, x, 3, (a*x^2)/2 + (b*x^3)/3}
{(a*x^2 + b*x^3)/x^2, x, 2, a*x + (b*x^2)/2}


{x^2*(a*x^2 + b*x^3)^2, x, 3, (a^2*x^7)/7 + (a*b*x^8)/4 + (b^2*x^9)/9}
{x*(a*x^2 + b*x^3)^2, x, 3, (a^2*x^6)/6 + (2*a*b*x^7)/7 + (b^2*x^8)/8}
{(a*x^2 + b*x^3)^2, x, 3, (a^2*x^5)/5 + (a*b*x^6)/3 + (b^2*x^7)/7}
{(a*x^2 + b*x^3)^2/x, x, 3, (a^2*x^4)/4 + (2*a*b*x^5)/5 + (b^2*x^6)/6}
{(a*x^2 + b*x^3)^2/x^2, x, 3, (a^2*x^3)/3 + (a*b*x^4)/2 + (b^2*x^5)/5}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^6/(a*x^2 + b*x^3), x, 3, -((a^3*x)/b^4) + (a^2*x^2)/(2*b^3) - (a*x^3)/(3*b^2) + x^4/(4*b) + (a^4*Log[a + b*x])/b^5}
{x^5/(a*x^2 + b*x^3), x, 3, (a^2*x)/b^3 - (a*x^2)/(2*b^2) + x^3/(3*b) - (a^3*Log[a + b*x])/b^4}
{x^4/(a*x^2 + b*x^3), x, 3, -((a*x)/b^2) + x^2/(2*b) + (a^2*Log[a + b*x])/b^3}
{x^3/(a*x^2 + b*x^3), x, 3, x/b - (a*Log[a + b*x])/b^2}
{x^2/(a*x^2 + b*x^3), x, 2, Log[a + b*x]/b}
{x^1/(a*x^2 + b*x^3), x, 3, Log[x]/a - Log[a + b*x]/a}
{x^0/(a*x^2 + b*x^3), x, 3, -(1/(a*x)) - (b*Log[x])/a^2 + (b*Log[a + b*x])/a^2}
{1/(x^1*(a*x^2 + b*x^3)), x, 3, -1/(2*a*x^2) + b/(a^2*x) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x])/a^3}
{1/(x^2*(a*x^2 + b*x^3)), x, 3, -1/(3*a*x^3) + b/(2*a^2*x^2) - b^2/(a^3*x) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x])/a^4}


{x^8/(a*x^2 + b*x^3)^2, x, 3, (3*a^2*x)/b^4 - (a*x^2)/b^3 + x^3/(3*b^2) - a^4/(b^5*(a + b*x)) - (4*a^3*Log[a + b*x])/b^5}
{x^7/(a*x^2 + b*x^3)^2, x, 3, -((2*a*x)/b^3) + x^2/(2*b^2) + a^3/(b^4*(a + b*x)) + (3*a^2*Log[a + b*x])/b^4}
{x^6/(a*x^2 + b*x^3)^2, x, 3, x/b^2 - a^2/(b^3*(a + b*x)) - (2*a*Log[a + b*x])/b^3}
{x^5/(a*x^2 + b*x^3)^2, x, 3, a/(b^2*(a + b*x)) + Log[a + b*x]/b^2}
{x^4/(a*x^2 + b*x^3)^2, x, 2, -(1/(b*(a + b*x)))}
{x^3/(a*x^2 + b*x^3)^2, x, 3, 1/(a*(a + b*x)) + Log[x]/a^2 - Log[a + b*x]/a^2}
{x^2/(a*x^2 + b*x^3)^2, x, 3, -(1/(a^2*x)) - b/(a^2*(a + b*x)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x])/a^3}
{x^1/(a*x^2 + b*x^3)^2, x, 3, -(1/(2*a^2*x^2)) + (2*b)/(a^3*x) + b^2/(a^3*(a + b*x)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x])/a^4}
{x^0/(a*x^2 + b*x^3)^2, x, 3, -(1/(3*a^2*x^3)) + b/(a^3*x^2) - (3*b^2)/(a^4*x) - b^3/(a^4*(a + b*x)) - (4*b^3*Log[x])/a^5 + (4*b^3*Log[a + b*x])/a^5}
{1/(x^1*(a*x^2 + b*x^3)^2), x, 3, -(1/(4*a^2*x^4)) + (2*b)/(3*a^3*x^3) - (3*b^2)/(2*a^4*x^2) + (4*b^3)/(a^5*x) + b^4/(a^5*(a + b*x)) + (5*b^4*Log[x])/a^6 - (5*b^4*Log[a + b*x])/a^6}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^3)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^2*Sqrt[a*x^2 + b*x^3], x, 4, (2*(a*x^2 + b*x^3)^(3/2))/(9*b) - (32*a^3*(a*x^2 + b*x^3)^(3/2))/(315*b^4*x^3) + (16*a^2*(a*x^2 + b*x^3)^(3/2))/(105*b^3*x^2) - (4*a*(a*x^2 + b*x^3)^(3/2))/(21*b^2*x)}
{x*Sqrt[a*x^2 + b*x^3], x, 3, (16*a^2*(a*x^2 + b*x^3)^(3/2))/(105*b^3*x^3) - (8*a*(a*x^2 + b*x^3)^(3/2))/(35*b^2*x^2) + (2*(a*x^2 + b*x^3)^(3/2))/(7*b*x)}
{Sqrt[a*x^2 + b*x^3], x, 2, -((4*a*(a*x^2 + b*x^3)^(3/2))/(15*b^2*x^3)) + (2*(a*x^2 + b*x^3)^(3/2))/(5*b*x^2)}
{Sqrt[a*x^2 + b*x^3]/x, x, 1, (2*(a*x^2 + b*x^3)^(3/2))/(3*b*x^3)}
{Sqrt[a*x^2 + b*x^3]/x^2, x, 2, (2*Sqrt[a*x^2 + b*x^3])/x - 2*Sqrt[a]*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]]}
{Sqrt[a*x^2 + b*x^3]/x^3, x, 2, -(Sqrt[a*x^2 + b*x^3]/x^2) - (b*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/Sqrt[a]}
{Sqrt[a*x^2 + b*x^3]/x^4, x, 3, -(Sqrt[a*x^2 + b*x^3]/(2*x^3)) - (b*Sqrt[a*x^2 + b*x^3])/(4*a*x^2) + (b^2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(4*a^(3/2))}
{Sqrt[a*x^2 + b*x^3]/x^5, x, 4, -(Sqrt[a*x^2 + b*x^3]/(3*x^4)) - (b*Sqrt[a*x^2 + b*x^3])/(12*a*x^3) + (b^2*Sqrt[a*x^2 + b*x^3])/(8*a^2*x^2) - (b^3*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(8*a^(5/2))}


{x^2*(a*x^2 + b*x^3)^(3/2), x, 6, (2*(a*x^2 + b*x^3)^(5/2))/(15*b) - (512*a^5*(a*x^2 + b*x^3)^(5/2))/(45045*b^6*x^5) + (256*a^4*(a*x^2 + b*x^3)^(5/2))/(9009*b^5*x^4) - (64*a^3*(a*x^2 + b*x^3)^(5/2))/(1287*b^4*x^3) + (32*a^2*(a*x^2 + b*x^3)^(5/2))/(429*b^3*x^2) - (4*a*(a*x^2 + b*x^3)^(5/2))/(39*b^2*x)}
{x*(a*x^2 + b*x^3)^(3/2), x, 5, (256*a^4*(a*x^2 + b*x^3)^(5/2))/(15015*b^5*x^5) - (128*a^3*(a*x^2 + b*x^3)^(5/2))/(3003*b^4*x^4) + (32*a^2*(a*x^2 + b*x^3)^(5/2))/(429*b^3*x^3) - (16*a*(a*x^2 + b*x^3)^(5/2))/(143*b^2*x^2) + (2*(a*x^2 + b*x^3)^(5/2))/(13*b*x)}
{(a*x^2 + b*x^3)^(3/2), x, 4, -((32*a^3*(a*x^2 + b*x^3)^(5/2))/(1155*b^4*x^5)) + (16*a^2*(a*x^2 + b*x^3)^(5/2))/(231*b^3*x^4) - (4*a*(a*x^2 + b*x^3)^(5/2))/(33*b^2*x^3) + (2*(a*x^2 + b*x^3)^(5/2))/(11*b*x^2)}
{(a*x^2 + b*x^3)^(3/2)/x, x, 3, (16*a^2*(a*x^2 + b*x^3)^(5/2))/(315*b^3*x^5) - (8*a*(a*x^2 + b*x^3)^(5/2))/(63*b^2*x^4) + (2*(a*x^2 + b*x^3)^(5/2))/(9*b*x^3)}
{(a*x^2 + b*x^3)^(3/2)/x^2, x, 2, -((4*a*(a*x^2 + b*x^3)^(5/2))/(35*b^2*x^5)) + (2*(a*x^2 + b*x^3)^(5/2))/(7*b*x^4)}
{(a*x^2 + b*x^3)^(3/2)/x^3, x, 1, (2*(a*x^2 + b*x^3)^(5/2))/(5*b*x^5)}
{(a*x^2 + b*x^3)^(3/2)/x^4, x, 3, (2*a*Sqrt[a*x^2 + b*x^3])/x + (2*(a*x^2 + b*x^3)^(3/2))/(3*x^3) - 2*a^(3/2)*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]]}
{(a*x^2 + b*x^3)^(3/2)/x^5, x, 3, (3*b*Sqrt[a*x^2 + b*x^3])/x - (a*x^2 + b*x^3)^(3/2)/x^4 - 3*Sqrt[a]*b*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]]}
{(a*x^2 + b*x^3)^(3/2)/x^6, x, 3, -((3*b*Sqrt[a*x^2 + b*x^3])/(4*x^2)) - (a*x^2 + b*x^3)^(3/2)/(2*x^5) - (3*b^2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(4*Sqrt[a])}
{(a*x^2 + b*x^3)^(3/2)/x^7, x, 4, -((b*Sqrt[a*x^2 + b*x^3])/(4*x^3)) - (b^2*Sqrt[a*x^2 + b*x^3])/(8*a*x^2) - (a*x^2 + b*x^3)^(3/2)/(3*x^6) + (b^3*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(8*a^(3/2))}
{(a*x^2 + b*x^3)^(3/2)/x^8, x, 5, -((b*Sqrt[a*x^2 + b*x^3])/(8*x^4)) - (b^2*Sqrt[a*x^2 + b*x^3])/(32*a*x^3) + (3*b^3*Sqrt[a*x^2 + b*x^3])/(64*a^2*x^2) - (a*x^2 + b*x^3)^(3/2)/(4*x^7) - (3*b^4*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(64*a^(5/2))}
{(a*x^2 + b*x^3)^(3/2)/x^9, x, 6, -((3*b*Sqrt[a*x^2 + b*x^3])/(40*x^5)) - (b^2*Sqrt[a*x^2 + b*x^3])/(80*a*x^4) + (b^3*Sqrt[a*x^2 + b*x^3])/(64*a^2*x^3) - (3*b^4*Sqrt[a*x^2 + b*x^3])/(128*a^3*x^2) - (a*x^2 + b*x^3)^(3/2)/(5*x^8) + (3*b^5*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(128*a^(7/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/Sqrt[a*x^2 + b*x^3], x, 4, (16*a^2*Sqrt[a*x^2 + b*x^3])/(35*b^3) - (32*a^3*Sqrt[a*x^2 + b*x^3])/(35*b^4*x) - (12*a*x*Sqrt[a*x^2 + b*x^3])/(35*b^2) + (2*x^2*Sqrt[a*x^2 + b*x^3])/(7*b)}
{x^3/Sqrt[a*x^2 + b*x^3], x, 3, -((8*a*Sqrt[a*x^2 + b*x^3])/(15*b^2)) + (16*a^2*Sqrt[a*x^2 + b*x^3])/(15*b^3*x) + (2*x*Sqrt[a*x^2 + b*x^3])/(5*b)}
{x^2/Sqrt[a*x^2 + b*x^3], x, 2, (2*Sqrt[a*x^2 + b*x^3])/(3*b) - (4*a*Sqrt[a*x^2 + b*x^3])/(3*b^2*x)}
{x^1/Sqrt[a*x^2 + b*x^3], x, 1, (2*Sqrt[a*x^2 + b*x^3])/(b*x)}
{x^0/Sqrt[a*x^2 + b*x^3], x, 1, -((2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/Sqrt[a])}
{1/(x^1*Sqrt[a*x^2 + b*x^3]), x, 2, -(Sqrt[a*x^2 + b*x^3]/(a*x^2)) + (b*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/a^(3/2)}
{1/(x^2*Sqrt[a*x^2 + b*x^3]), x, 3, (3*b*Sqrt[a*x^2 + b*x^3])/(4*a^2*x^2) - Sqrt[a*x^2 + b*x^3]/(2*a*x^3) - (3*b^2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(4*a^(5/2))}
{1/(x^3*Sqrt[a*x^2 + b*x^3]), x, 4, -(Sqrt[a*x^2 + b*x^3]/(3*a*x^4)) + (5*b*Sqrt[a*x^2 + b*x^3])/(12*a^2*x^3) - (5*b^2*Sqrt[a*x^2 + b*x^3])/(8*a^3*x^2) + (5*b^3*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(8*a^(7/2))}


{x^6/(a*x^2 + b*x^3)^(3/2), x, 4, -((2*x^4)/(b*Sqrt[a*x^2 + b*x^3])) - (16*a*Sqrt[a*x^2 + b*x^3])/(5*b^3) + (32*a^2*Sqrt[a*x^2 + b*x^3])/(5*b^4*x) + (12*x*Sqrt[a*x^2 + b*x^3])/(5*b^2)}
{x^5/(a*x^2 + b*x^3)^(3/2), x, 3, -((2*x^3)/(b*Sqrt[a*x^2 + b*x^3])) + (8*Sqrt[a*x^2 + b*x^3])/(3*b^2) - (16*a*Sqrt[a*x^2 + b*x^3])/(3*b^3*x)}
{x^4/(a*x^2 + b*x^3)^(3/2), x, 2, -((2*x^2)/(b*Sqrt[a*x^2 + b*x^3])) + (4*Sqrt[a*x^2 + b*x^3])/(b^2*x)}
{x^3/(a*x^2 + b*x^3)^(3/2), x, 1, -((2*x)/(b*Sqrt[a*x^2 + b*x^3]))}
{x^2/(a*x^2 + b*x^3)^(3/2), x, 2, (2*x)/(a*Sqrt[a*x^2 + b*x^3]) - (2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/a^(3/2)}
{x^1/(a*x^2 + b*x^3)^(3/2), x, 3, 2/(a*Sqrt[a*x^2 + b*x^3]) - (3*Sqrt[a*x^2 + b*x^3])/(a^2*x^2) + (3*b*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/a^(5/2)}
{x^0/(a*x^2 + b*x^3)^(3/2), x, 4, 2/(a*x*Sqrt[a*x^2 + b*x^3]) - (5*Sqrt[a*x^2 + b*x^3])/(2*a^2*x^3) + (15*b*Sqrt[a*x^2 + b*x^3])/(4*a^3*x^2) - (15*b^2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(4*a^(7/2))}
{1/(x^1*(a*x^2 + b*x^3)^(3/2)), x, 5, 2/(a*x^2*Sqrt[a*x^2 + b*x^3]) - (7*Sqrt[a*x^2 + b*x^3])/(3*a^2*x^4) + (35*b*Sqrt[a*x^2 + b*x^3])/(12*a^3*x^3) - (35*b^2*Sqrt[a*x^2 + b*x^3])/(8*a^4*x^2) + (35*b^3*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(8*a^(9/2))}
{1/(x^2*(a*x^2 + b*x^3)^(3/2)), x, 6, 2/(a*x^3*Sqrt[a*x^2 + b*x^3]) - (9*Sqrt[a*x^2 + b*x^3])/(4*a^2*x^5) + (21*b*Sqrt[a*x^2 + b*x^3])/(8*a^3*x^4) - (105*b^2*Sqrt[a*x^2 + b*x^3])/(32*a^4*x^3) + (315*b^3*Sqrt[a*x^2 + b*x^3])/(64*a^5*x^2) - (315*b^4*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/(64*a^(11/2))}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a x^2+b x^3)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a x^2+b x^3)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(7/2)/Sqrt[a*x^2 + b*x^3], x, 4, (5*a^2*Sqrt[a*x^2 + b*x^3])/(8*b^3*Sqrt[x]) - (5*a*Sqrt[x]*Sqrt[a*x^2 + b*x^3])/(12*b^2) + (x^(3/2)*Sqrt[a*x^2 + b*x^3])/(3*b) - (5*a^3*ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x^2 + b*x^3]])/(8*b^(7/2))}
{x^(5/2)/Sqrt[a*x^2 + b*x^3], x, 3, -((3*a*Sqrt[a*x^2 + b*x^3])/(4*b^2*Sqrt[x])) + (Sqrt[x]*Sqrt[a*x^2 + b*x^3])/(2*b) + (3*a^2*ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x^2 + b*x^3]])/(4*b^(5/2))}
{x^(3/2)/Sqrt[a*x^2 + b*x^3], x, 2, Sqrt[a*x^2 + b*x^3]/(b*Sqrt[x]) - (a*ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x^2 + b*x^3]])/b^(3/2)}
{x^(1/2)/Sqrt[a*x^2 + b*x^3], x, 1, (2*ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x^2 + b*x^3]])/Sqrt[b]}
{1/(x^(1/2)*Sqrt[a*x^2 + b*x^3]), x, 1, -((2*Sqrt[a*x^2 + b*x^3])/(a*x^(3/2)))}
{1/(x^(3/2)*Sqrt[a*x^2 + b*x^3]), x, 2, -((2*Sqrt[a*x^2 + b*x^3])/(3*a*x^(5/2))) + (4*b*Sqrt[a*x^2 + b*x^3])/(3*a^2*x^(3/2))}
{1/(x^(5/2)*Sqrt[a*x^2 + b*x^3]), x, 3, -((2*Sqrt[a*x^2 + b*x^3])/(5*a*x^(7/2))) + (8*b*Sqrt[a*x^2 + b*x^3])/(15*a^2*x^(5/2)) - (16*b^2*Sqrt[a*x^2 + b*x^3])/(15*a^3*x^(3/2))}
{1/(x^(7/2)*Sqrt[a*x^2 + b*x^3]), x, 4, -((2*Sqrt[a*x^2 + b*x^3])/(7*a*x^(9/2))) + (12*b*Sqrt[a*x^2 + b*x^3])/(35*a^2*x^(7/2)) - (16*b^2*Sqrt[a*x^2 + b*x^3])/(35*a^3*x^(5/2)) + (32*b^3*Sqrt[a*x^2 + b*x^3])/(35*a^4*x^(3/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^3)^p when p is symbolic*)


{(a*x^2 + b*x^3)^n/x^(3*n - 1), x, 2, (x^(-1 - 3*n)*(a*x^2 + b*x^3)^(1 + n))/(2*b) - (x^(-1 - 3*n)*(a*x^2 + b*x^3)^(1 + n)*Hypergeometric2F1[1, 2, 2 - n, -((b*x)/a)])/(2*b)}
{(a*x^2 + b*x^3)^n/x^(3*n + 0), x, 1, (x^(-1 - 3*n)*(a*x^2 + b*x^3)^(1 + n)*Hypergeometric2F1[1, 2, 2 - n, -((b*x)/a)])/(a*(1 - n))}
{(a*x^2 + b*x^3)^n/x^(3*n + 1), x, 2, -((x^(-2 - 3*n)*(a*x^2 + b*x^3)^(1 + n))/(a*n)) + (b*x^(-1 - 3*n)*(a*x^2 + b*x^3)^(1 + n)*Hypergeometric2F1[1, 2, 2 - n, -((b*x)/a)])/(a^2*(1 - n)*n)}
{(a*x^2 + b*x^3)^n/x^(3*n + 2), x, 1, -((a*x^2 + b*x^3)^(1 + n)/(x^(3*(1 + n))*(a*(1 + n))))}
{(a*x^2 + b*x^3)^n/x^(3*n + 3), x, 2, -((x^(-4 - 3*n)*(a*x^2 + b*x^3)^(1 + n))/(a*(2 + n))) + (b*(a*x^2 + b*x^3)^(1 + n))/(x^(3*(1 + n))*(a^2*(1 + n)*(2 + n)))}
{(a*x^2 + b*x^3)^n/x^(3*n + 4), x, 3, -((x^(-5 - 3*n)*(a*x^2 + b*x^3)^(1 + n))/(a*(3 + n))) + (2*b*x^(-4 - 3*n)*(a*x^2 + b*x^3)^(1 + n))/(a^2*(2 + n)*(3 + n)) - (2*b^2*(a*x^2 + b*x^3)^(1 + n))/(x^(3*(1 + n))*(a^3*(1 + n)*(2 + n)*(3 + n)))}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^4)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^4)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^m*(b*x^2 + c*x^4), x, 3, (b*x^(3 + m))/(3 + m) + (c*x^(5 + m))/(5 + m)}

{x^2*(b*x^2 + c*x^4), x, 3, (b*x^5)/5 + (c*x^7)/7}
{x^1*(b*x^2 + c*x^4), x, 3, (b*x^4)/4 + (c*x^6)/6}
{x^0*(b*x^2 + c*x^4), x, 1, (b*x^3)/3 + (c*x^5)/5}
{(b*x^2 + c*x^4)/x^1, x, 3, (b*x^2)/2 + (c*x^4)/4}
{(b*x^2 + c*x^4)/x^2, x, 2, b*x + (c*x^3)/3}
{(b*x^2 + c*x^4)/x^3, x, 3, (c*x^2)/2 + b*Log[x]}
{(b*x^2 + c*x^4)/x^4, x, 3, -(b/x) + c*x}
{(b*x^2 + c*x^4)/x^5, x, 3, -(b/(2*x^2)) + c*Log[x]}
{(b*x^2 + c*x^4)/x^6, x, 3, -(b/(3*x^3)) - c/x}
{(b*x^2 + c*x^4)/x^7, x, 3, -(b/(4*x^4)) - c/(2*x^2)}
{(b*x^2 + c*x^4)/x^8, x, 3, -(b/(5*x^5)) - c/(3*x^3)}


{x^m*(b*x^2 + c*x^4)^2, x, 3, (b^2*x^(5 + m))/(5 + m) + (2*b*c*x^(7 + m))/(7 + m) + (c^2*x^(9 + m))/(9 + m)}

{x^0*(b*x^2 + c*x^4)^2, x, 3, (b^2*x^5)/5 + (2/7)*b*c*x^7 + (c^2*x^9)/9}
{(b*x^2 + c*x^4)^2/x^1, x, 4, (b^2*x^4)/4 + (1/3)*b*c*x^6 + (c^2*x^8)/8}
{(b*x^2 + c*x^4)^2/x^2, x, 3, (b^2*x^3)/3 + (2/5)*b*c*x^5 + (c^2*x^7)/7}
{(b*x^2 + c*x^4)^2/x^3, x, 2, (b + c*x^2)^3/(6*c)}
{(b*x^2 + c*x^4)^2/x^4, x, 3, b^2*x + (2/3)*b*c*x^3 + (c^2*x^5)/5}
{(b*x^2 + c*x^4)^2/x^5, x, 3, b*c*x^2 + (c^2*x^4)/4 + b^2*Log[x]}
{(b*x^2 + c*x^4)^2/x^6, x, 3, -(b^2/x) + 2*b*c*x + (c^2*x^3)/3}
{(b*x^2 + c*x^4)^2/x^7, x, 3, -(b^2/(2*x^2)) + (c^2*x^2)/2 + 2*b*c*Log[x]}
{(b*x^2 + c*x^4)^2/x^8, x, 3, -(b^2/(3*x^3)) - (2*b*c)/x + c^2*x}
{(b*x^2 + c*x^4)^2/x^9, x, 3, -(b^2/(4*x^4)) - (b*c)/x^2 + c^2*Log[x]}
{(b*x^2 + c*x^4)^2/x^10, x, 3, -(b^2/(5*x^5)) - (2*b*c)/(3*x^3) - c^2/x}
{(b*x^2 + c*x^4)^2/x^11, x, 2, -((b + c*x^2)^3/(6*b*x^6))}
{(b*x^2 + c*x^4)^2/x^12, x, 3, -(b^2/(7*x^7)) - (2*b*c)/(5*x^5) - c^2/(3*x^3)}


{x^m*(b*x^2 + c*x^4)^3, x, 3, (b^3*x^(7 + m))/(7 + m) + (3*b^2*c*x^(9 + m))/(9 + m) + (3*b*c^2*x^(11 + m))/(11 + m) + (c^3*x^(13 + m))/(13 + m)}

{(b*x^2 + c*x^4)^3/x^2, x, 3, (b^3*x^5)/5 + (3/7)*b^2*c*x^7 + (1/3)*b*c^2*x^9 + (c^3*x^11)/11}
{(b*x^2 + c*x^4)^3/x^3, x, 4, -((b*(b + c*x^2)^4)/(8*c^2)) + (b + c*x^2)^5/(10*c^2)}
{(b*x^2 + c*x^4)^3/x^4, x, 3, (b^3*x^3)/3 + (3/5)*b^2*c*x^5 + (3/7)*b*c^2*x^7 + (c^3*x^9)/9}
{(b*x^2 + c*x^4)^3/x^5, x, 2, (b + c*x^2)^4/(8*c)}
{(b*x^2 + c*x^4)^3/x^6, x, 3, b^3*x + b^2*c*x^3 + (3/5)*b*c^2*x^5 + (c^3*x^7)/7}
{(b*x^2 + c*x^4)^3/x^7, x, 3, (3/2)*b^2*c*x^2 + (3/4)*b*c^2*x^4 + (c^3*x^6)/6 + b^3*Log[x]}
{(b*x^2 + c*x^4)^3/x^8, x, 3, -(b^3/x) + 3*b^2*c*x + b*c^2*x^3 + (c^3*x^5)/5}
{(b*x^2 + c*x^4)^3/x^9, x, 3, -(b^3/(2*x^2)) + (3/2)*b*c^2*x^2 + (c^3*x^4)/4 + 3*b^2*c*Log[x]}
{(b*x^2 + c*x^4)^3/x^10, x, 3, -(b^3/(3*x^3)) - (3*b^2*c)/x + 3*b*c^2*x + (c^3*x^3)/3}
{(b*x^2 + c*x^4)^3/x^11, x, 3, -(b^3/(4*x^4)) - (3*b^2*c)/(2*x^2) + (c^3*x^2)/2 + 3*b*c^2*Log[x]}
{(b*x^2 + c*x^4)^3/x^12, x, 3, -(b^3/(5*x^5)) - (b^2*c)/x^3 - (3*b*c^2)/x + c^3*x}
{(b*x^2 + c*x^4)^3/x^13, x, 3, -(b^3/(6*x^6)) - (3*b^2*c)/(4*x^4) - (3*b*c^2)/(2*x^2) + c^3*Log[x]}
{(b*x^2 + c*x^4)^3/x^14, x, 3, -(b^3/(7*x^7)) - (3*b^2*c)/(5*x^5) - (b*c^2)/x^3 - c^3/x}
{(b*x^2 + c*x^4)^3/x^15, x, 2, -((b + c*x^2)^4/(8*b*x^8))}
{(b*x^2 + c*x^4)^3/x^16, x, 3, -(b^3/(9*x^9)) - (3*b^2*c)/(7*x^7) - (3*b*c^2)/(5*x^5) - c^3/(3*x^3)}
{(b*x^2 + c*x^4)^3/x^17, x, 3, -(b^3/(10*x^10)) - (3*b^2*c)/(8*x^8) - (b*c^2)/(2*x^6) - c^3/(4*x^4)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/(a*x^2 + b*x^4), x, 3, x/b - (Sqrt[a]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(3/2)}
{x^3/(a*x^2 + b*x^4), x, 2, Log[a + b*x^2]/(2*b)}
{x^2/(a*x^2 + b*x^4), x, 2, ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(Sqrt[a]*Sqrt[b])}
{x/(a*x^2 + b*x^4), x, 2, Log[x]/a - Log[a + b*x^2]/(2*a)}
{1/(a*x^2 + b*x^4), x, 3, -(1/(a*x)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(3/2)}
{1/(x*(a*x^2 + b*x^4)), x, 3, -(1/(2*a*x^2)) - (b*Log[x])/a^2 + (b*Log[a + b*x^2])/(2*a^2)}
{1/(x^2*(a*x^2 + b*x^4)), x, 4, -(1/(3*a*x^3)) + b/(a^2*x) + (b^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(5/2)}
{1/(x^3*(a*x^2 + b*x^4)), x, 4, -(1/(4*a*x^4)) + b/(2*a^2*x^2) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x^2])/(2*a^3)}
{1/(x^4*(a*x^2 + b*x^4)), x, 5, -(1/(5*a*x^5)) + b/(3*a^2*x^3) - b^2/(a^3*x) - (b^(5/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(7/2)}


{x^10/(b*x^2 + c*x^4), x, 4, -((b^3*x)/c^4) + (b^2*x^3)/(3*c^3) - (b*x^5)/(5*c^2) + x^7/(7*c) + (b^(7/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/c^(9/2)}
{x^9/(b*x^2 + c*x^4), x, 4, (b^2*x^2)/(2*c^3) - (b*x^4)/(4*c^2) + x^6/(6*c) - (b^3*Log[b + c*x^2])/(2*c^4)}
{x^8/(b*x^2 + c*x^4), x, 4, (b^2*x)/c^3 - (b*x^3)/(3*c^2) + x^5/(5*c) - (b^(5/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/c^(7/2)}
{x^7/(b*x^2 + c*x^4), x, 4, -((b*x^2)/(2*c^2)) + x^4/(4*c) + (b^2*Log[b + c*x^2])/(2*c^3)}
{x^6/(b*x^2 + c*x^4), x, 4, -((b*x)/c^2) + x^3/(3*c) + (b^(3/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/c^(5/2)}
{x^5/(b*x^2 + c*x^4), x, 3, x^2/(2*c) - (b*Log[b + c*x^2])/(2*c^2)}
{x^4/(b*x^2 + c*x^4), x, 3, x/c - (Sqrt[b]*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/c^(3/2)}
{x^3/(b*x^2 + c*x^4), x, 2, Log[b + c*x^2]/(2*c)}
{x^2/(b*x^2 + c*x^4), x, 2, ArcTan[(Sqrt[c]*x)/Sqrt[b]]/(Sqrt[b]*Sqrt[c])}
{x^1/(b*x^2 + c*x^4), x, 2, Log[x]/b - Log[b + c*x^2]/(2*b)}
{x^0/(b*x^2 + c*x^4), x, 3, -(1/(b*x)) - (Sqrt[c]*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/b^(3/2)}
{1/(x^1*(b*x^2 + c*x^4)), x, 3, -(1/(2*b*x^2)) - (c*Log[x])/b^2 + (c*Log[b + c*x^2])/(2*b^2)}
{1/(x^2*(b*x^2 + c*x^4)), x, 4, -(1/(3*b*x^3)) + c/(b^2*x) + (c^(3/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/b^(5/2)}
{1/(x^3*(b*x^2 + c*x^4)), x, 4, -(1/(4*b*x^4)) + c/(2*b^2*x^2) + (c^2*Log[x])/b^3 - (c^2*Log[b + c*x^2])/(2*b^3)}
{1/(x^4*(b*x^2 + c*x^4)), x, 5, -(1/(5*b*x^5)) + c/(3*b^2*x^3) - c^2/(b^3*x) - (c^(5/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/b^(7/2)}
{1/(x^5*(b*x^2 + c*x^4)), x, 5, -(1/(6*b*x^6)) + c/(4*b^2*x^4) - c^2/(2*b^3*x^2) - (c^3*Log[x])/b^4 + (c^3*Log[b + c*x^2])/(2*b^4)}


{x^12/(b*x^2 + c*x^4)^2, x, 5, (7*b^2*x)/(2*c^4) - (7*b*x^3)/(6*c^3) + (7*x^5)/(10*c^2) - x^7/(2*c*(b + c*x^2)) - (7*b^(5/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(2*c^(9/2))}
{x^11/(b*x^2 + c*x^4)^2, x, 4, -((b*x^2)/c^3) + x^4/(4*c^2) + b^3/(2*c^4*(b + c*x^2)) + (3*b^2*Log[b + c*x^2])/(2*c^4)}
{x^10/(b*x^2 + c*x^4)^2, x, 5, -((5*b*x)/(2*c^3)) + (5*x^3)/(6*c^2) - x^5/(2*c*(b + c*x^2)) + (5*b^(3/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(2*c^(7/2))}
{x^9/(b*x^2 + c*x^4)^2, x, 4, x^2/(2*c^2) - b^2/(2*c^3*(b + c*x^2)) - (b*Log[b + c*x^2])/c^3}
{x^8/(b*x^2 + c*x^4)^2, x, 4, (3*x)/(2*c^2) - x^3/(2*c*(b + c*x^2)) - (3*Sqrt[b]*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(2*c^(5/2))}
{x^7/(b*x^2 + c*x^4)^2, x, 4, b/(2*c^2*(b + c*x^2)) + Log[b + c*x^2]/(2*c^2)}
{x^6/(b*x^2 + c*x^4)^2, x, 3, -(x/(2*c*(b + c*x^2))) + ArcTan[(Sqrt[c]*x)/Sqrt[b]]/(2*Sqrt[b]*c^(3/2))}
{x^5/(b*x^2 + c*x^4)^2, x, 2, -(1/(2*c*(b + c*x^2)))}
{x^4/(b*x^2 + c*x^4)^2, x, 3, x/(2*b*(b + c*x^2)) + ArcTan[(Sqrt[c]*x)/Sqrt[b]]/(2*b^(3/2)*Sqrt[c])}
{x^3/(b*x^2 + c*x^4)^2, x, 3, 1/(2*b*(b + c*x^2)) + Log[x]/b^2 - Log[b + c*x^2]/(2*b^2)}
{x^2/(b*x^2 + c*x^4)^2, x, 4, -(3/(2*b^2*x)) + 1/(2*b*x*(b + c*x^2)) - (3*Sqrt[c]*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(2*b^(5/2))}
{x^1/(b*x^2 + c*x^4)^2, x, 4, -(1/(b^2*x^2)) + 1/(2*b*x^2*(b + c*x^2)) - (2*c*Log[x])/b^3 + (c*Log[b + c*x^2])/b^3}
{x^0/(b*x^2 + c*x^4)^2, x, 5, -(5/(6*b^2*x^3)) + (5*c)/(2*b^3*x) + 1/(2*b*x^3*(b + c*x^2)) + (5*c^(3/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(2*b^(7/2))}
{1/(x^1*(b*x^2 + c*x^4)^2), x, 5, -(3/(4*b^2*x^4)) + (3*c)/(2*b^3*x^2) + 1/(2*b*x^4*(b + c*x^2)) + (3*c^2*Log[x])/b^4 - (3*c^2*Log[b + c*x^2])/(2*b^4)}
{1/(x^2*(b*x^2 + c*x^4)^2), x, 6, -(7/(10*b^2*x^5)) + (7*c)/(6*b^3*x^3) - (7*c^2)/(2*b^4*x) + 1/(2*b*x^5*(b + c*x^2)) - (7*c^(5/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(2*b^(9/2))}


{x^14/(b*x^2 + c*x^4)^3, x, 6, -((35*b*x)/(8*c^4)) + (35*x^3)/(24*c^3) - x^7/(4*c*(b + c*x^2)^2) - (7*x^5)/(8*c^2*(b + c*x^2)) + (35*b^(3/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*c^(9/2))}
{x^13/(b*x^2 + c*x^4)^3, x, 4, x^2/(2*c^3) + b^3/(4*c^4*(b + c*x^2)^2) - (3*b^2)/(2*c^4*(b + c*x^2)) - (3*b*Log[b + c*x^2])/(2*c^4)}
{x^12/(b*x^2 + c*x^4)^3, x, 5, (15*x)/(8*c^3) - x^5/(4*c*(b + c*x^2)^2) - (5*x^3)/(8*c^2*(b + c*x^2)) - (15*Sqrt[b]*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*c^(7/2))}
{x^11/(b*x^2 + c*x^4)^3, x, 4, -(b^2/(4*c^3*(b + c*x^2)^2)) + b/(c^3*(b + c*x^2)) + Log[b + c*x^2]/(2*c^3)}
{x^10/(b*x^2 + c*x^4)^3, x, 4, -(x^3/(4*c*(b + c*x^2)^2)) - (3*x)/(8*c^2*(b + c*x^2)) + (3*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*Sqrt[b]*c^(5/2))}
{x^9/(b*x^2 + c*x^4)^3, x, 2, x^4/(4*b*(b + c*x^2)^2)}
{x^8/(b*x^2 + c*x^4)^3, x, 4, -(x/(4*c*(b + c*x^2)^2)) + x/(8*b*c*(b + c*x^2)) + ArcTan[(Sqrt[c]*x)/Sqrt[b]]/(8*b^(3/2)*c^(3/2))}
{x^7/(b*x^2 + c*x^4)^3, x, 2, -(1/(4*c*(b + c*x^2)^2))}
{x^6/(b*x^2 + c*x^4)^3, x, 4, x/(4*b*(b + c*x^2)^2) + (3*x)/(8*b^2*(b + c*x^2)) + (3*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*b^(5/2)*Sqrt[c])}
{x^5/(b*x^2 + c*x^4)^3, x, 4, 1/(4*b*(b + c*x^2)^2) + 1/(2*b^2*(b + c*x^2)) + Log[x]/b^3 - Log[b + c*x^2]/(2*b^3)}
{x^4/(b*x^2 + c*x^4)^3, x, 5, -(15/(8*b^3*x)) + 1/(4*b*x*(b + c*x^2)^2) + 5/(8*b^2*x*(b + c*x^2)) - (15*Sqrt[c]*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*b^(7/2))}
{x^3/(b*x^2 + c*x^4)^3, x, 5, -(3/(2*b^3*x^2)) + 1/(4*b*x^2*(b + c*x^2)^2) + 3/(4*b^2*x^2*(b + c*x^2)) - (3*c*Log[x])/b^4 + (3*c*Log[b + c*x^2])/(2*b^4)}
{x^2/(b*x^2 + c*x^4)^3, x, 6, -(35/(24*b^3*x^3)) + (35*c)/(8*b^4*x) + 1/(4*b*x^3*(b + c*x^2)^2) + 7/(8*b^2*x^3*(b + c*x^2)) + (35*c^(3/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*b^(9/2))}
{x^1/(b*x^2 + c*x^4)^3, x, 6, -(3/(2*b^3*x^4)) + (3*c)/(b^4*x^2) + 1/(4*b*x^4*(b + c*x^2)^2) + 1/(b^2*x^4*(b + c*x^2)) + (6*c^2*Log[x])/b^5 - (3*c^2*Log[b + c*x^2])/b^5}
{x^0/(b*x^2 + c*x^4)^3, x, 7, -(63/(40*b^3*x^5)) + (21*c)/(8*b^4*x^3) - (63*c^2)/(8*b^5*x) + 1/(4*b*x^5*(b + c*x^2)^2) + 9/(8*b^2*x^5*(b + c*x^2)) - (63*c^(5/2)*ArcTan[(Sqrt[c]*x)/Sqrt[b]])/(8*b^(11/2))}
{1/(x^1*(b*x^2 + c*x^4)^3), x, 7, -(5/(3*b^3*x^6)) + (5*c)/(2*b^4*x^4) - (5*c^2)/(b^5*x^2) + 1/(4*b*x^6*(b + c*x^2)^2) + 5/(4*b^2*x^6*(b + c*x^2)) - (10*c^3*Log[x])/b^6 + (5*c^3*Log[b + c*x^2])/b^6}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^4)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^5*Sqrt[b*x^2 + c*x^4], x, 6, (5*b^3*Sqrt[b*x^2 + c*x^4])/(128*c^3) - (5*b^2*x^2*Sqrt[b*x^2 + c*x^4])/(192*c^2) + (b*x^4*Sqrt[b*x^2 + c*x^4])/(48*c) + (1/8)*x^6*Sqrt[b*x^2 + c*x^4] - (5*b^4*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(128*c^(7/2))}
{x^3*Sqrt[b*x^2 + c*x^4], x, 5, -((b^2*Sqrt[b*x^2 + c*x^4])/(16*c^2)) + (b*x^2*Sqrt[b*x^2 + c*x^4])/(24*c) + (1/6)*x^4*Sqrt[b*x^2 + c*x^4] + (b^3*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(16*c^(5/2))}
{x^1*Sqrt[b*x^2 + c*x^4], x, 4, (b*Sqrt[b*x^2 + c*x^4])/(8*c) + (1/4)*x^2*Sqrt[b*x^2 + c*x^4] - (b^2*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(8*c^(3/2))}
{Sqrt[b*x^2 + c*x^4]/x^1, x, 3, (1/2)*Sqrt[b*x^2 + c*x^4] + (b*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(2*Sqrt[c])}
{Sqrt[b*x^2 + c*x^4]/x^3, x, 3, -(Sqrt[b*x^2 + c*x^4]/x^2) + Sqrt[c]*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]]}
{Sqrt[b*x^2 + c*x^4]/x^5, x, 1, -((b*x^2 + c*x^4)^(3/2)/(3*b*x^6))}
{Sqrt[b*x^2 + c*x^4]/x^7, x, 2, -((b*x^2 + c*x^4)^(3/2)/(5*b*x^8)) + (2*c*(b*x^2 + c*x^4)^(3/2))/(15*b^2*x^6)}
{Sqrt[b*x^2 + c*x^4]/x^9, x, 3, -((b*x^2 + c*x^4)^(3/2)/(7*b*x^10)) + (4*c*(b*x^2 + c*x^4)^(3/2))/(35*b^2*x^8) - (8*c^2*(b*x^2 + c*x^4)^(3/2))/(105*b^3*x^6)}
{Sqrt[b*x^2 + c*x^4]/x^11, x, 4, -((b*x^2 + c*x^4)^(3/2)/(9*b*x^12)) + (2*c*(b*x^2 + c*x^4)^(3/2))/(21*b^2*x^10) - (8*c^2*(b*x^2 + c*x^4)^(3/2))/(105*b^3*x^8) + (16*c^3*(b*x^2 + c*x^4)^(3/2))/(315*b^4*x^6)}
{Sqrt[b*x^2 + c*x^4]/x^13, x, 5, -((b*x^2 + c*x^4)^(3/2)/(11*b*x^14)) + (8*c*(b*x^2 + c*x^4)^(3/2))/(99*b^2*x^12) - (16*c^2*(b*x^2 + c*x^4)^(3/2))/(231*b^3*x^10) + (64*c^3*(b*x^2 + c*x^4)^(3/2))/(1155*b^4*x^8) - (128*c^4*(b*x^2 + c*x^4)^(3/2))/(3465*b^5*x^6)}

{x^4*Sqrt[b*x^2 + c*x^4], x, 3, (8*b^2*(b*x^2 + c*x^4)^(3/2))/(105*c^3*x^3) - (4*b*(b*x^2 + c*x^4)^(3/2))/(35*c^2*x) + (x*(b*x^2 + c*x^4)^(3/2))/(7*c)}
{x^2*Sqrt[b*x^2 + c*x^4], x, 2, -((2*b*(b*x^2 + c*x^4)^(3/2))/(15*c^2*x^3)) + (b*x^2 + c*x^4)^(3/2)/(5*c*x)}
{x^0*Sqrt[b*x^2 + c*x^4], x, 1, (b*x^2 + c*x^4)^(3/2)/(3*c*x^3)}
{Sqrt[b*x^2 + c*x^4]/x^2, x, 2, Sqrt[b*x^2 + c*x^4]/x - Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]]}
{Sqrt[b*x^2 + c*x^4]/x^4, x, 2, -(Sqrt[b*x^2 + c*x^4]/(2*x^3)) - (c*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(2*Sqrt[b])}
{Sqrt[b*x^2 + c*x^4]/x^6, x, 3, (c*Sqrt[b*x^2 + c*x^4])/(8*b*x^3) - (b*x^2 + c*x^4)^(3/2)/(4*b*x^7) + (c^2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(8*b^(3/2))}
{Sqrt[b*x^2 + c*x^4]/x^8, x, 4, -((c^2*Sqrt[b*x^2 + c*x^4])/(16*b^2*x^3)) - (b*x^2 + c*x^4)^(3/2)/(6*b*x^9) + (c*(b*x^2 + c*x^4)^(3/2))/(8*b^2*x^7) - (c^3*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(16*b^(5/2))}


{x^3*(b*x^2 + c*x^4)^(3/2), x, 7, (3*b^4*Sqrt[b*x^2 + c*x^4])/(256*c^3) - (b^3*x^2*Sqrt[b*x^2 + c*x^4])/(128*c^2) + (b^2*x^4*Sqrt[b*x^2 + c*x^4])/(160*c) + (3/80)*b*x^6*Sqrt[b*x^2 + c*x^4] + (1/10)*x^4*(b*x^2 + c*x^4)^(3/2) - (3*b^5*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(256*c^(7/2))}
{x^1*(b*x^2 + c*x^4)^(3/2), x, 6, -((3*b^3*Sqrt[b*x^2 + c*x^4])/(128*c^2)) + (b^2*x^2*Sqrt[b*x^2 + c*x^4])/(64*c) + (1/16)*b*x^4*Sqrt[b*x^2 + c*x^4] + (1/8)*x^2*(b*x^2 + c*x^4)^(3/2) + (3*b^4*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(128*c^(5/2))}
{(b*x^2 + c*x^4)^(3/2)/x^1, x, 5, (b^2*Sqrt[b*x^2 + c*x^4])/(16*c) + (1/8)*b*x^2*Sqrt[b*x^2 + c*x^4] + (1/6)*(b*x^2 + c*x^4)^(3/2) - (b^3*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(16*c^(3/2))}
{(b*x^2 + c*x^4)^(3/2)/x^3, x, 4, (3/8)*b*Sqrt[b*x^2 + c*x^4] + (b*x^2 + c*x^4)^(3/2)/(4*x^2) + (3*b^2*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(8*Sqrt[c])}
{(b*x^2 + c*x^4)^(3/2)/x^5, x, 4, (3/2)*c*Sqrt[b*x^2 + c*x^4] - (b*x^2 + c*x^4)^(3/2)/x^4 + (3/2)*b*Sqrt[c]*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]]}
{(b*x^2 + c*x^4)^(3/2)/x^7, x, 4, -((c*Sqrt[b*x^2 + c*x^4])/x^2) - (b*x^2 + c*x^4)^(3/2)/(3*x^6) + c^(3/2)*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]]}
{(b*x^2 + c*x^4)^(3/2)/x^9, x, 1, -((b*x^2 + c*x^4)^(5/2)/(5*b*x^10))}
{(b*x^2 + c*x^4)^(3/2)/x^11, x, 2, -((b*x^2 + c*x^4)^(5/2)/(7*b*x^12)) + (2*c*(b*x^2 + c*x^4)^(5/2))/(35*b^2*x^10)}
{(b*x^2 + c*x^4)^(3/2)/x^13, x, 3, -((b*x^2 + c*x^4)^(5/2)/(9*b*x^14)) + (4*c*(b*x^2 + c*x^4)^(5/2))/(63*b^2*x^12) - (8*c^2*(b*x^2 + c*x^4)^(5/2))/(315*b^3*x^10)}
{(b*x^2 + c*x^4)^(3/2)/x^15, x, 4, -((b*x^2 + c*x^4)^(5/2)/(11*b*x^16)) + (2*c*(b*x^2 + c*x^4)^(5/2))/(33*b^2*x^14) - (8*c^2*(b*x^2 + c*x^4)^(5/2))/(231*b^3*x^12) + (16*c^3*(b*x^2 + c*x^4)^(5/2))/(1155*b^4*x^10)}
{(b*x^2 + c*x^4)^(3/2)/x^17, x, 5, -((b*x^2 + c*x^4)^(5/2)/(13*b*x^18)) + (8*c*(b*x^2 + c*x^4)^(5/2))/(143*b^2*x^16) - (16*c^2*(b*x^2 + c*x^4)^(5/2))/(429*b^3*x^14) + (64*c^3*(b*x^2 + c*x^4)^(5/2))/(3003*b^4*x^12) - (128*c^4*(b*x^2 + c*x^4)^(5/2))/(15015*b^5*x^10)}

{x^6*(b*x^2 + c*x^4)^(3/2), x, 5, (128*b^4*(b*x^2 + c*x^4)^(5/2))/(15015*c^5*x^5) - (64*b^3*(b*x^2 + c*x^4)^(5/2))/(3003*c^4*x^3) + (16*b^2*(b*x^2 + c*x^4)^(5/2))/(429*c^3*x) - (8*b*x*(b*x^2 + c*x^4)^(5/2))/(143*c^2) + (x^3*(b*x^2 + c*x^4)^(5/2))/(13*c)}
{x^4*(b*x^2 + c*x^4)^(3/2), x, 4, -((16*b^3*(b*x^2 + c*x^4)^(5/2))/(1155*c^4*x^5)) + (8*b^2*(b*x^2 + c*x^4)^(5/2))/(231*c^3*x^3) - (2*b*(b*x^2 + c*x^4)^(5/2))/(33*c^2*x) + (x*(b*x^2 + c*x^4)^(5/2))/(11*c)}
{x^2*(b*x^2 + c*x^4)^(3/2), x, 3, (8*b^2*(b*x^2 + c*x^4)^(5/2))/(315*c^3*x^5) - (4*b*(b*x^2 + c*x^4)^(5/2))/(63*c^2*x^3) + (b*x^2 + c*x^4)^(5/2)/(9*c*x)}
{x^0*(b*x^2 + c*x^4)^(3/2), x, 2, -((2*b*(b*x^2 + c*x^4)^(5/2))/(35*c^2*x^5)) + (b*x^2 + c*x^4)^(5/2)/(7*c*x^3)}
{(b*x^2 + c*x^4)^(3/2)/x^2, x, 1, (b*x^2 + c*x^4)^(5/2)/(5*c*x^5)}
{(b*x^2 + c*x^4)^(3/2)/x^4, x, 3, (b*Sqrt[b*x^2 + c*x^4])/x + (b*x^2 + c*x^4)^(3/2)/(3*x^3) - b^(3/2)*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]]}
{(b*x^2 + c*x^4)^(3/2)/x^6, x, 3, (3*c*Sqrt[b*x^2 + c*x^4])/(2*x) - (b*x^2 + c*x^4)^(3/2)/(2*x^5) - (3/2)*Sqrt[b]*c*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]]}
{(b*x^2 + c*x^4)^(3/2)/x^8, x, 3, -((3*c*Sqrt[b*x^2 + c*x^4])/(8*x^3)) - (b*x^2 + c*x^4)^(3/2)/(4*x^7) - (3*c^2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(8*Sqrt[b])}
{(b*x^2 + c*x^4)^(3/2)/x^10, x, 4, (c^2*Sqrt[b*x^2 + c*x^4])/(16*b*x^3) + (c*(b*x^2 + c*x^4)^(3/2))/(24*b*x^7) - (b*x^2 + c*x^4)^(5/2)/(6*b*x^11) + (c^3*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(16*b^(3/2))}
{(b*x^2 + c*x^4)^(3/2)/x^12, x, 5, -((3*c^3*Sqrt[b*x^2 + c*x^4])/(128*b^2*x^3)) - (c^2*(b*x^2 + c*x^4)^(3/2))/(64*b^2*x^7) - (b*x^2 + c*x^4)^(5/2)/(8*b*x^13) + (c*(b*x^2 + c*x^4)^(5/2))/(16*b^2*x^11) - (3*c^4*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(128*b^(5/2))}
{(b*x^2 + c*x^4)^(3/2)/x^14, x, 6, (3*c^4*Sqrt[b*x^2 + c*x^4])/(256*b^3*x^3) + (c^3*(b*x^2 + c*x^4)^(3/2))/(128*b^3*x^7) - (b*x^2 + c*x^4)^(5/2)/(10*b*x^15) + (c*(b*x^2 + c*x^4)^(5/2))/(16*b^2*x^13) - (c^2*(b*x^2 + c*x^4)^(5/2))/(32*b^3*x^11) + (3*c^5*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(256*b^(7/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^7/Sqrt[b*x^2 + c*x^4], x, 5, (5*b^2*Sqrt[b*x^2 + c*x^4])/(16*c^3) - (5*b*x^2*Sqrt[b*x^2 + c*x^4])/(24*c^2) + (x^4*Sqrt[b*x^2 + c*x^4])/(6*c) - (5*b^3*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(16*c^(7/2))}
{x^5/Sqrt[b*x^2 + c*x^4], x, 4, -((3*b*Sqrt[b*x^2 + c*x^4])/(8*c^2)) + (x^2*Sqrt[b*x^2 + c*x^4])/(4*c) + (3*b^2*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(8*c^(5/2))}
{x^3/Sqrt[b*x^2 + c*x^4], x, 3, Sqrt[b*x^2 + c*x^4]/(2*c) - (b*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(2*c^(3/2))}
{x^1/Sqrt[b*x^2 + c*x^4], x, 2, ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]]/Sqrt[c]}
{1/(x^1*Sqrt[b*x^2 + c*x^4]), x, 1, -(Sqrt[b*x^2 + c*x^4]/(b*x^2))}
{1/(x^3*Sqrt[b*x^2 + c*x^4]), x, 2, -(Sqrt[b*x^2 + c*x^4]/(3*b*x^4)) + (2*c*Sqrt[b*x^2 + c*x^4])/(3*b^2*x^2)}
{1/(x^5*Sqrt[b*x^2 + c*x^4]), x, 3, -(Sqrt[b*x^2 + c*x^4]/(5*b*x^6)) + (4*c*Sqrt[b*x^2 + c*x^4])/(15*b^2*x^4) - (8*c^2*Sqrt[b*x^2 + c*x^4])/(15*b^3*x^2)}
{1/(x^7*Sqrt[b*x^2 + c*x^4]), x, 4, -(Sqrt[b*x^2 + c*x^4]/(7*b*x^8)) + (6*c*Sqrt[b*x^2 + c*x^4])/(35*b^2*x^6) - (8*c^2*Sqrt[b*x^2 + c*x^4])/(35*b^3*x^4) + (16*c^3*Sqrt[b*x^2 + c*x^4])/(35*b^4*x^2)}

{x^4/Sqrt[b*x^2 + c*x^4], x, 2, -((2*b*Sqrt[b*x^2 + c*x^4])/(3*c^2*x)) + (x*Sqrt[b*x^2 + c*x^4])/(3*c)}
{x^2/Sqrt[b*x^2 + c*x^4], x, 1, Sqrt[b*x^2 + c*x^4]/(c*x)}
{x^0/Sqrt[b*x^2 + c*x^4], x, 1, -(ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]]/Sqrt[b])}
{1/(x^2*Sqrt[b*x^2 + c*x^4]), x, 2, -(Sqrt[b*x^2 + c*x^4]/(2*b*x^3)) + (c*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(2*b^(3/2))}
{1/(x^4*Sqrt[b*x^2 + c*x^4]), x, 3, -(Sqrt[b*x^2 + c*x^4]/(4*b*x^5)) + (3*c*Sqrt[b*x^2 + c*x^4])/(8*b^2*x^3) - (3*c^2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(8*b^(5/2))}


{x^9/(b*x^2 + c*x^4)^(3/2), x, 5, -(x^6/(c*Sqrt[b*x^2 + c*x^4])) - (15*b*Sqrt[b*x^2 + c*x^4])/(8*c^3) + (5*x^2*Sqrt[b*x^2 + c*x^4])/(4*c^2) + (15*b^2*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(8*c^(7/2))}
{x^7/(b*x^2 + c*x^4)^(3/2), x, 4, -(x^4/(c*Sqrt[b*x^2 + c*x^4])) + (3*Sqrt[b*x^2 + c*x^4])/(2*c^2) - (3*b*ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]])/(2*c^(5/2))}
{x^5/(b*x^2 + c*x^4)^(3/2), x, 3, -(x^2/(c*Sqrt[b*x^2 + c*x^4])) + ArcTanh[(Sqrt[c]*x^2)/Sqrt[b*x^2 + c*x^4]]/c^(3/2)}
{x^3/(b*x^2 + c*x^4)^(3/2), x, 1, x^2/(b*Sqrt[b*x^2 + c*x^4])}
{x^1/(b*x^2 + c*x^4)^(3/2), x, 2, 1/(b*Sqrt[b*x^2 + c*x^4]) - (2*Sqrt[b*x^2 + c*x^4])/(b^2*x^2)}
{1/(x^1*(b*x^2 + c*x^4)^(3/2)), x, 3, 1/(b*x^2*Sqrt[b*x^2 + c*x^4]) - (4*Sqrt[b*x^2 + c*x^4])/(3*b^2*x^4) + (8*c*Sqrt[b*x^2 + c*x^4])/(3*b^3*x^2)}
{1/(x^3*(b*x^2 + c*x^4)^(3/2)), x, 4, 1/(b*x^4*Sqrt[b*x^2 + c*x^4]) - (6*Sqrt[b*x^2 + c*x^4])/(5*b^2*x^6) + (8*c*Sqrt[b*x^2 + c*x^4])/(5*b^3*x^4) - (16*c^2*Sqrt[b*x^2 + c*x^4])/(5*b^4*x^2)}
{1/(x^5*(b*x^2 + c*x^4)^(3/2)), x, 5, 1/(b*x^6*Sqrt[b*x^2 + c*x^4]) - (8*Sqrt[b*x^2 + c*x^4])/(7*b^2*x^8) + (48*c*Sqrt[b*x^2 + c*x^4])/(35*b^3*x^6) - (64*c^2*Sqrt[b*x^2 + c*x^4])/(35*b^4*x^4) + (128*c^3*Sqrt[b*x^2 + c*x^4])/(35*b^5*x^2)}

{x^6/(b*x^2 + c*x^4)^(3/2), x, 2, -(x^3/(c*Sqrt[b*x^2 + c*x^4])) + (2*Sqrt[b*x^2 + c*x^4])/(c^2*x)}
{x^4/(b*x^2 + c*x^4)^(3/2), x, 1, -(x/(c*Sqrt[b*x^2 + c*x^4]))}
{x^2/(b*x^2 + c*x^4)^(3/2), x, 2, x/(b*Sqrt[b*x^2 + c*x^4]) - ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]]/b^(3/2)}
{x^0/(b*x^2 + c*x^4)^(3/2), x, 3, 1/(b*x*Sqrt[b*x^2 + c*x^4]) - (3*Sqrt[b*x^2 + c*x^4])/(2*b^2*x^3) + (3*c*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(2*b^(5/2))}
{1/(x^2*(b*x^2 + c*x^4)^(3/2)), x, 4, 1/(b*x^3*Sqrt[b*x^2 + c*x^4]) - (5*Sqrt[b*x^2 + c*x^4])/(4*b^2*x^5) + (15*c*Sqrt[b*x^2 + c*x^4])/(8*b^3*x^3) - (15*c^2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + c*x^4]])/(8*b^(7/2))}


{x^3/Sqrt[3*x^2 - 4*x^4], x, 3, (-(1/8))*Sqrt[3*x^2 - 4*x^4] - (3/32)*ArcSin[1 - (8*x^2)/3]}
{x^3/Sqrt[-3*x^2 - 4*x^4], x, 3, (-(1/8))*Sqrt[-3*x^2 - 4*x^4] - (3/32)*ArcSin[1 + (8*x^2)/3]}
{x^3/Sqrt[3*x^2 + 4*x^4], x, 3, (1/8)*Sqrt[3*x^2 + 4*x^4] - (3/16)*ArcTanh[(2*x^2)/Sqrt[3*x^2 + 4*x^4]]}
{x^3/Sqrt[-3*x^2 + 4*x^4], x, 3, (1/8)*Sqrt[-3*x^2 + 4*x^4] + (3/16)*ArcTanh[(2*x^2)/Sqrt[-3*x^2 + 4*x^4]]}
{x^3/Sqrt[a*x^2 + b*x^4], x, 3, Sqrt[a*x^2 + b*x^4]/(2*b) - (a*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x^2 + b*x^4]])/(2*b^(3/2))}
{x^3/Sqrt[a*x^2 - b*x^4], x, 3, -(Sqrt[a*x^2 - b*x^4]/(2*b)) + (a*ArcTan[(Sqrt[b]*x^2)/Sqrt[a*x^2 - b*x^4]])/(2*b^(3/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a x^2+b x^4)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(7/2)*(b*x^2 + c*x^4), x, 3, (2/13)*b*x^(13/2) + (2/17)*c*x^(17/2)}
{x^(5/2)*(b*x^2 + c*x^4), x, 3, (2/11)*b*x^(11/2) + (2/15)*c*x^(15/2)}
{x^(3/2)*(b*x^2 + c*x^4), x, 3, (2/9)*b*x^(9/2) + (2/13)*c*x^(13/2)}
{x^(1/2)*(b*x^2 + c*x^4), x, 3, (2/7)*b*x^(7/2) + (2/11)*c*x^(11/2)}
{(b*x^2 + c*x^4)/x^(1/2), x, 3, (2/5)*b*x^(5/2) + (2/9)*c*x^(9/2)}
{(b*x^2 + c*x^4)/x^(3/2), x, 3, (2/3)*b*x^(3/2) + (2/7)*c*x^(7/2)}
{(b*x^2 + c*x^4)/x^(5/2), x, 3, 2*b*Sqrt[x] + (2/5)*c*x^(5/2)}
{(b*x^2 + c*x^4)/x^(7/2), x, 3, -((2*b)/Sqrt[x]) + (2/3)*c*x^(3/2)}


{x^(7/2)*(b*x^2 + c*x^4)^2, x, 3, (2/17)*b^2*x^(17/2) + (4/21)*b*c*x^(21/2) + (2/25)*c^2*x^(25/2)}
{x^(5/2)*(b*x^2 + c*x^4)^2, x, 3, (2/15)*b^2*x^(15/2) + (4/19)*b*c*x^(19/2) + (2/23)*c^2*x^(23/2)}
{x^(3/2)*(b*x^2 + c*x^4)^2, x, 3, (2/13)*b^2*x^(13/2) + (4/17)*b*c*x^(17/2) + (2/21)*c^2*x^(21/2)}
{x^(1/2)*(b*x^2 + c*x^4)^2, x, 3, (2/11)*b^2*x^(11/2) + (4/15)*b*c*x^(15/2) + (2/19)*c^2*x^(19/2)}
{(b*x^2 + c*x^4)^2/x^(1/2), x, 3, (2/9)*b^2*x^(9/2) + (4/13)*b*c*x^(13/2) + (2/17)*c^2*x^(17/2)}
{(b*x^2 + c*x^4)^2/x^(3/2), x, 3, (2/7)*b^2*x^(7/2) + (4/11)*b*c*x^(11/2) + (2/15)*c^2*x^(15/2)}
{(b*x^2 + c*x^4)^2/x^(5/2), x, 3, (2/5)*b^2*x^(5/2) + (4/9)*b*c*x^(9/2) + (2/13)*c^2*x^(13/2)}
{(b*x^2 + c*x^4)^2/x^(7/2), x, 3, (2/3)*b^2*x^(3/2) + (4/7)*b*c*x^(7/2) + (2/11)*c^2*x^(11/2)}


{x^(7/2)*(b*x^2 + c*x^4)^3, x, 3, (2/21)*b^3*x^(21/2) + (6/25)*b^2*c*x^(25/2) + (6/29)*b*c^2*x^(29/2) + (2/33)*c^3*x^(33/2)}
{x^(5/2)*(b*x^2 + c*x^4)^3, x, 3, (2/19)*b^3*x^(19/2) + (6/23)*b^2*c*x^(23/2) + (2/9)*b*c^2*x^(27/2) + (2/31)*c^3*x^(31/2)}
{x^(3/2)*(b*x^2 + c*x^4)^3, x, 3, (2/17)*b^3*x^(17/2) + (2/7)*b^2*c*x^(21/2) + (6/25)*b*c^2*x^(25/2) + (2/29)*c^3*x^(29/2)}
{x^(1/2)*(b*x^2 + c*x^4)^3, x, 3, (2/15)*b^3*x^(15/2) + (6/19)*b^2*c*x^(19/2) + (6/23)*b*c^2*x^(23/2) + (2/27)*c^3*x^(27/2)}
{(b*x^2 + c*x^4)^3/x^(1/2), x, 3, (2/13)*b^3*x^(13/2) + (6/17)*b^2*c*x^(17/2) + (2/7)*b*c^2*x^(21/2) + (2/25)*c^3*x^(25/2)}
{(b*x^2 + c*x^4)^3/x^(3/2), x, 3, (2/11)*b^3*x^(11/2) + (2/5)*b^2*c*x^(15/2) + (6/19)*b*c^2*x^(19/2) + (2/23)*c^3*x^(23/2)}
{(b*x^2 + c*x^4)^3/x^(5/2), x, 3, (2/9)*b^3*x^(9/2) + (6/13)*b^2*c*x^(13/2) + (6/17)*b*c^2*x^(17/2) + (2/21)*c^3*x^(21/2)}
{(b*x^2 + c*x^4)^3/x^(7/2), x, 3, (2/7)*b^3*x^(7/2) + (6/11)*b^2*c*x^(11/2) + (2/5)*b*c^2*x^(15/2) + (2/19)*c^3*x^(19/2)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(13/2)/(b*x^2 + c*x^4), x, 7, -((2*b*x^(3/2))/(3*c^2)) + (2*x^(7/2))/(7*c) + ((-b)^(7/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(11/4) - ((-b)^(7/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(11/4)}
{x^(11/2)/(b*x^2 + c*x^4), x, 7, -((2*b*Sqrt[x])/c^2) + (2*x^(5/2))/(5*c) - ((-b)^(5/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(9/4) - ((-b)^(5/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(9/4)}
{x^(9/2)/(b*x^2 + c*x^4), x, 6, (2*x^(3/2))/(3*c) + ((-b)^(3/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(7/4) - ((-b)^(3/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(7/4)}
{x^(7/2)/(b*x^2 + c*x^4), x, 6, (2*Sqrt[x])/c - ((-b)^(1/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(5/4) - ((-b)^(1/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/c^(5/4)}
{x^(5/2)/(b*x^2 + c*x^4), x, 5, ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/((-b)^(1/4)*c^(3/4)) - ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/((-b)^(1/4)*c^(3/4))}
{x^(3/2)/(b*x^2 + c*x^4), x, 5, -(ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/((-b)^(3/4)*c^(1/4))) - ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/((-b)^(3/4)*c^(1/4))}
{x^(1/2)/(b*x^2 + c*x^4), x, 6, -(2/(b*Sqrt[x])) + (c^(1/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(5/4) - (c^(1/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(5/4)}
{1/(x^(1/2)*(b*x^2 + c*x^4)), x, 6, -(2/(3*b*x^(3/2))) - (c^(3/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(7/4) - (c^(3/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(7/4)}
{1/(x^(3/2)*(b*x^2 + c*x^4)), x, 7, -(2/(5*b*x^(5/2))) + (2*c)/(b^2*Sqrt[x]) + (c^(5/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(9/4) - (c^(5/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(9/4)}
{1/(x^(5/2)*(b*x^2 + c*x^4)), x, 7, -(2/(7*b*x^(7/2))) + (2*c)/(3*b^2*x^(3/2)) - (c^(7/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(11/4) - (c^(7/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(11/4)}
{1/(x^(7/2)*(b*x^2 + c*x^4)), x, 8, -(2/(9*b*x^(9/2))) + (2*c)/(5*b^2*x^(5/2)) - (2*c^2)/(b^3*Sqrt[x]) + (c^(9/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(13/4) - (c^(9/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(-b)^(13/4)}


{x^(19/2)/(b*x^2 + c*x^4)^2, x, 8, -((9*b*Sqrt[x])/(2*c^3)) + (9*x^(5/2))/(10*c^2) - x^(9/2)/(2*c*(b + c*x^2)) - (9*(-b)^(5/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*c^(13/4)) - (9*(-b)^(5/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*c^(13/4))}
{x^(17/2)/(b*x^2 + c*x^4)^2, x, 7, (7*x^(3/2))/(6*c^2) - x^(7/2)/(2*c*(b + c*x^2)) + (7*(-b)^(3/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*c^(11/4)) - (7*(-b)^(3/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*c^(11/4))}
{x^(15/2)/(b*x^2 + c*x^4)^2, x, 7, (5*Sqrt[x])/(2*c^2) - x^(5/2)/(2*c*(b + c*x^2)) - (5*(-b)^(1/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*c^(9/4)) - (5*(-b)^(1/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*c^(9/4))}
{x^(13/2)/(b*x^2 + c*x^4)^2, x, 6, -(x^(3/2)/(2*c*(b + c*x^2))) + (3*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(1/4)*c^(7/4)) - (3*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(1/4)*c^(7/4))}
{x^(11/2)/(b*x^2 + c*x^4)^2, x, 6, -(Sqrt[x]/(2*c*(b + c*x^2))) - ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/(4*(-b)^(3/4)*c^(5/4)) - ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/(4*(-b)^(3/4)*c^(5/4))}
{x^(9/2)/(b*x^2 + c*x^4)^2, x, 6, x^(3/2)/(2*b*(b + c*x^2)) - ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/(4*(-b)^(5/4)*c^(3/4)) + ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)]/(4*(-b)^(5/4)*c^(3/4))}
{x^(7/2)/(b*x^2 + c*x^4)^2, x, 6, Sqrt[x]/(2*b*(b + c*x^2)) + (3*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(7/4)*c^(1/4)) + (3*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(7/4)*c^(1/4))}
{x^(5/2)/(b*x^2 + c*x^4)^2, x, 7, -(5/(2*b^2*Sqrt[x])) + 1/(2*b*Sqrt[x]*(b + c*x^2)) - (5*c^(1/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(9/4)) + (5*c^(1/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(9/4))}
{x^(3/2)/(b*x^2 + c*x^4)^2, x, 7, -(7/(6*b^2*x^(3/2))) + 1/(2*b*x^(3/2)*(b + c*x^2)) + (7*c^(3/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(11/4)) + (7*c^(3/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(11/4))}
{x^(1/2)/(b*x^2 + c*x^4)^2, x, 8, -(9/(10*b^2*x^(5/2))) + (9*c)/(2*b^3*Sqrt[x]) + 1/(2*b*x^(5/2)*(b + c*x^2)) - (9*c^(5/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(13/4)) + (9*c^(5/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(13/4))}
{1/(x^(1/2)*(b*x^2 + c*x^4)^2), x, 8, -(11/(14*b^2*x^(7/2))) + (11*c)/(6*b^3*x^(3/2)) + 1/(2*b*x^(7/2)*(b + c*x^2)) + (11*c^(7/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(15/4)) + (11*c^(7/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(15/4))}
{1/(x^(3/2)*(b*x^2 + c*x^4)^2), x, 9, -(13/(18*b^2*x^(9/2))) + (13*c)/(10*b^3*x^(5/2)) - (13*c^2)/(2*b^4*Sqrt[x]) + 1/(2*b*x^(9/2)*(b + c*x^2)) - (13*c^(9/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(17/4)) + (13*c^(9/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(4*(-b)^(17/4))}


{x^(23/2)/(b*x^2 + c*x^4)^3, x, 8, (45*Sqrt[x])/(16*c^3) - x^(9/2)/(4*c*(b + c*x^2)^2) - (9*x^(5/2))/(16*c^2*(b + c*x^2)) - (45*(-b)^(1/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*c^(13/4)) - (45*(-b)^(1/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*c^(13/4))}
{x^(21/2)/(b*x^2 + c*x^4)^3, x, 7, -(x^(7/2)/(4*c*(b + c*x^2)^2)) - (7*x^(3/2))/(16*c^2*(b + c*x^2)) + (21*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(1/4)*c^(11/4)) - (21*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(1/4)*c^(11/4))}
{x^(19/2)/(b*x^2 + c*x^4)^3, x, 7, -(x^(5/2)/(4*c*(b + c*x^2)^2)) - (5*Sqrt[x])/(16*c^2*(b + c*x^2)) - (5*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(3/4)*c^(9/4)) - (5*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(3/4)*c^(9/4))}
{x^(17/2)/(b*x^2 + c*x^4)^3, x, 7, -(x^(3/2)/(4*c*(b + c*x^2)^2)) + (3*x^(3/2))/(16*b*c*(b + c*x^2)) - (3*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(5/4)*c^(7/4)) + (3*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(5/4)*c^(7/4))}
{x^(15/2)/(b*x^2 + c*x^4)^3, x, 7, -(Sqrt[x]/(4*c*(b + c*x^2)^2)) + Sqrt[x]/(16*b*c*(b + c*x^2)) + (3*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(7/4)*c^(5/4)) + (3*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(7/4)*c^(5/4))}
{x^(13/2)/(b*x^2 + c*x^4)^3, x, 7, x^(3/2)/(4*b*(b + c*x^2)^2) + (5*x^(3/2))/(16*b^2*(b + c*x^2)) + (5*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(9/4)*c^(3/4)) - (5*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(9/4)*c^(3/4))}
{x^(11/2)/(b*x^2 + c*x^4)^3, x, 7, Sqrt[x]/(4*b*(b + c*x^2)^2) + (7*Sqrt[x])/(16*b^2*(b + c*x^2)) - (21*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(11/4)*c^(1/4)) - (21*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(11/4)*c^(1/4))}
{x^(9/2)/(b*x^2 + c*x^4)^3, x, 8, -(45/(16*b^3*Sqrt[x])) + 1/(4*b*Sqrt[x]*(b + c*x^2)^2) + 9/(16*b^2*Sqrt[x]*(b + c*x^2)) + (45*c^(1/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(13/4)) - (45*c^(1/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(13/4))}
{x^(7/2)/(b*x^2 + c*x^4)^3, x, 8, -(77/(48*b^3*x^(3/2))) + 1/(4*b*x^(3/2)*(b + c*x^2)^2) + 11/(16*b^2*x^(3/2)*(b + c*x^2)) - (77*c^(3/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(15/4)) - (77*c^(3/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(15/4))}
{x^(5/2)/(b*x^2 + c*x^4)^3, x, 9, -(117/(80*b^3*x^(5/2))) + (117*c)/(16*b^4*Sqrt[x]) + 1/(4*b*x^(5/2)*(b + c*x^2)^2) + 13/(16*b^2*x^(5/2)*(b + c*x^2)) + (117*c^(5/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(17/4)) - (117*c^(5/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(17/4))}
{x^(3/2)/(b*x^2 + c*x^4)^3, x, 9, -(165/(112*b^3*x^(7/2))) + (55*c)/(16*b^4*x^(3/2)) + 1/(4*b*x^(7/2)*(b + c*x^2)^2) + 15/(16*b^2*x^(7/2)*(b + c*x^2)) - (165*c^(7/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(19/4)) - (165*c^(7/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(19/4))}
{x^(1/2)/(b*x^2 + c*x^4)^3, x, 10, -(221/(144*b^3*x^(9/2))) + (221*c)/(80*b^4*x^(5/2)) - (221*c^2)/(16*b^5*Sqrt[x]) + 1/(4*b*x^(9/2)*(b + c*x^2)^2) + 17/(16*b^2*x^(9/2)*(b + c*x^2)) + (221*c^(9/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(21/4)) - (221*c^(9/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(21/4))}
{1/(x^(1/2)*(b*x^2 + c*x^4)^3), x, 10, -(285/(176*b^3*x^(11/2))) + (285*c)/(112*b^4*x^(7/2)) - (95*c^2)/(16*b^5*x^(3/2)) + 1/(4*b*x^(11/2)*(b + c*x^2)^2) + 19/(16*b^2*x^(11/2)*(b + c*x^2)) - (285*c^(11/4)*ArcTan[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(23/4)) - (285*c^(11/4)*ArcTanh[(c^(1/4)*Sqrt[x])/(-b)^(1/4)])/(32*(-b)^(23/4))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a x^2+b x^4)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(9/2)*(b*x^2 + c*x^4)^(1/2), x, 8, (4*b^3*Sqrt[b*x^2 + c*x^4])/(77*c^3*Sqrt[x]) - (12*b^2*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(385*c^2) + (4*b*x^(7/2)*Sqrt[b*x^2 + c*x^4])/(165*c) + (2/15)*x^(11/2)*Sqrt[b*x^2 + c*x^4] + (4*b^(17/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(77*(-c)^(13/4)*Sqrt[b*x^2 + c*x^4])}
{x^(7/2)*(b*x^2 + c*x^4)^(1/2), x, 7, -((28*b^2*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(585*c^2)) + (4*b*x^(5/2)*Sqrt[b*x^2 + c*x^4])/(117*c) + (2/13)*x^(9/2)*Sqrt[b*x^2 + c*x^4] + (28*b^(15/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(195*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4]) - (28*b^(15/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(195*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4])}
{x^(5/2)*(b*x^2 + c*x^4)^(1/2), x, 7, -((20*b^2*Sqrt[b*x^2 + c*x^4])/(231*c^2*Sqrt[x])) + (4*b*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(77*c) + (2/11)*x^(7/2)*Sqrt[b*x^2 + c*x^4] + (20*b^(13/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(231*(-c)^(9/4)*Sqrt[b*x^2 + c*x^4])}
{x^(3/2)*(b*x^2 + c*x^4)^(1/2), x, 6, (4*b*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(45*c) + (2/9)*x^(5/2)*Sqrt[b*x^2 + c*x^4] + (4*b^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*(-c)^(7/4)*Sqrt[b*x^2 + c*x^4]) - (4*b^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*(-c)^(7/4)*Sqrt[b*x^2 + c*x^4])}
{x^(1/2)*(b*x^2 + c*x^4)^(1/2), x, 6, (4*b*Sqrt[b*x^2 + c*x^4])/(21*c*Sqrt[x]) + (2/7)*x^(3/2)*Sqrt[b*x^2 + c*x^4] + (4*b^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(21*(-c)^(5/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(1/2), x, 5, (2/5)*Sqrt[x]*Sqrt[b*x^2 + c*x^4] + (4*b^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*(-c)^(3/4)*Sqrt[b*x^2 + c*x^4]) - (4*b^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*(-c)^(3/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(3/2), x, 5, (2*Sqrt[b*x^2 + c*x^4])/(3*Sqrt[x]) + (4*b^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*(-c)^(1/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(5/2), x, 5, -((2*Sqrt[b*x^2 + c*x^4])/x^(3/2)) - (4*b^(3/4)*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/Sqrt[b*x^2 + c*x^4] + (4*b^(3/4)*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/Sqrt[b*x^2 + c*x^4]}
{(b*x^2 + c*x^4)^(1/2)/x^(7/2), x, 5, -((2*Sqrt[b*x^2 + c*x^4])/(3*x^(5/2))) - (4*b^(1/4)*(-c)^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(9/2), x, 6, -((2*Sqrt[b*x^2 + c*x^4])/(5*x^(7/2))) - (4*c*Sqrt[b*x^2 + c*x^4])/(5*b*x^(3/2)) + (4*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*b^(1/4)*Sqrt[b*x^2 + c*x^4]) - (4*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*b^(1/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(11/2), x, 6, -((2*Sqrt[b*x^2 + c*x^4])/(7*x^(9/2))) - (4*c*Sqrt[b*x^2 + c*x^4])/(21*b*x^(5/2)) - (4*(-c)^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(21*b^(3/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(13/2), x, 7, -((2*Sqrt[b*x^2 + c*x^4])/(9*x^(11/2))) - (4*c*Sqrt[b*x^2 + c*x^4])/(45*b*x^(7/2)) + (4*c^2*Sqrt[b*x^2 + c*x^4])/(15*b^2*x^(3/2)) + (4*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(5/4)*Sqrt[b*x^2 + c*x^4]) - (4*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(5/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(1/2)/x^(15/2), x, 7, -((2*Sqrt[b*x^2 + c*x^4])/(11*x^(13/2))) - (4*c*Sqrt[b*x^2 + c*x^4])/(77*b*x^(9/2)) + (20*c^2*Sqrt[b*x^2 + c*x^4])/(231*b^2*x^(5/2)) - (20*(-c)^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(231*b^(7/4)*Sqrt[b*x^2 + c*x^4])}


{x^(5/2)*(b*x^2 + c*x^4)^(3/2), x, 9, (24*b^4*Sqrt[b*x^2 + c*x^4])/(1463*c^3*Sqrt[x]) - (72*b^3*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(7315*c^2) + (8*b^2*x^(7/2)*Sqrt[b*x^2 + c*x^4])/(1045*c) + (4/95)*b*x^(11/2)*Sqrt[b*x^2 + c*x^4] + (2/19)*x^(7/2)*(b*x^2 + c*x^4)^(3/2) + (24*b^(21/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(1463*(-c)^(13/4)*Sqrt[b*x^2 + c*x^4])}
{x^(3/2)*(b*x^2 + c*x^4)^(3/2), x, 8, -((56*b^3*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(3315*c^2)) + (8*b^2*x^(5/2)*Sqrt[b*x^2 + c*x^4])/(663*c) + (12/221)*b*x^(9/2)*Sqrt[b*x^2 + c*x^4] + (2/17)*x^(5/2)*(b*x^2 + c*x^4)^(3/2) + (56*b^(19/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(1105*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4]) - (56*b^(19/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(1105*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4])}
{x^(1/2)*(b*x^2 + c*x^4)^(3/2), x, 8, -((8*b^3*Sqrt[b*x^2 + c*x^4])/(231*c^2*Sqrt[x])) + (8*b^2*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(385*c) + (4/55)*b*x^(7/2)*Sqrt[b*x^2 + c*x^4] + (2/15)*x^(3/2)*(b*x^2 + c*x^4)^(3/2) + (8*b^(17/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(231*(-c)^(9/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(1/2), x, 7, (8*b^2*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(195*c) + (4/39)*b*x^(5/2)*Sqrt[b*x^2 + c*x^4] + (2/13)*Sqrt[x]*(b*x^2 + c*x^4)^(3/2) + (8*b^(15/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(65*(-c)^(7/4)*Sqrt[b*x^2 + c*x^4]) - (8*b^(15/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(65*(-c)^(7/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(3/2), x, 7, (8*b^2*Sqrt[b*x^2 + c*x^4])/(77*c*Sqrt[x]) + (12/77)*b*x^(3/2)*Sqrt[b*x^2 + c*x^4] + (2*(b*x^2 + c*x^4)^(3/2))/(11*Sqrt[x]) + (8*b^(13/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(77*(-c)^(5/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(5/2), x, 6, (4/15)*b*Sqrt[x]*Sqrt[b*x^2 + c*x^4] + (2*(b*x^2 + c*x^4)^(3/2))/(9*x^(3/2)) + (8*b^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*(-c)^(3/4)*Sqrt[b*x^2 + c*x^4]) - (8*b^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*(-c)^(3/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(7/2), x, 6, (4*b*Sqrt[b*x^2 + c*x^4])/(7*Sqrt[x]) + (2*(b*x^2 + c*x^4)^(3/2))/(7*x^(5/2)) + (8*b^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(7*(-c)^(1/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(9/2), x, 6, (12/5)*c*Sqrt[x]*Sqrt[b*x^2 + c*x^4] - (2*(b*x^2 + c*x^4)^(3/2))/x^(7/2) - (24*b^(7/4)*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*Sqrt[b*x^2 + c*x^4]) + (24*b^(7/4)*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(11/2), x, 6, (4*c*Sqrt[b*x^2 + c*x^4])/(3*Sqrt[x]) - (2*(b*x^2 + c*x^4)^(3/2))/(3*x^(9/2)) - (8*b^(5/4)*(-c)^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(13/2), x, 6, -((12*c*Sqrt[b*x^2 + c*x^4])/(5*x^(3/2))) - (2*(b*x^2 + c*x^4)^(3/2))/(5*x^(11/2)) + (24*b^(3/4)*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*Sqrt[b*x^2 + c*x^4]) - (24*b^(3/4)*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(15/2), x, 6, -((4*c*Sqrt[b*x^2 + c*x^4])/(7*x^(5/2))) - (2*(b*x^2 + c*x^4)^(3/2))/(7*x^(13/2)) + (8*b^(1/4)*(-c)^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(7*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(17/2), x, 7, -((8*c^2*Sqrt[b*x^2 + c*x^4])/(15*b*x^(3/2))) - (4*c*Sqrt[b*x^2 + c*x^4])/(15*x^(7/2)) - (2*(b*x^2 + c*x^4)^(3/2))/(9*x^(15/2)) - (8*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(1/4)*Sqrt[b*x^2 + c*x^4]) + (8*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(1/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(19/2), x, 7, -((12*c*Sqrt[b*x^2 + c*x^4])/(77*x^(9/2))) - (8*c^2*Sqrt[b*x^2 + c*x^4])/(77*b*x^(5/2)) - (2*(b*x^2 + c*x^4)^(3/2))/(11*x^(17/2)) + (8*(-c)^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(77*b^(3/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(21/2), x, 8, (8*c^3*Sqrt[b*x^2 + c*x^4])/(65*b^2*x^(3/2)) - (4*c*Sqrt[b*x^2 + c*x^4])/(39*x^(11/2)) - (8*c^2*Sqrt[b*x^2 + c*x^4])/(195*b*x^(7/2)) - (2*(b*x^2 + c*x^4)^(3/2))/(13*x^(19/2)) - (8*(-c)^(13/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(65*b^(5/4)*Sqrt[b*x^2 + c*x^4]) + (8*(-c)^(13/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(65*b^(5/4)*Sqrt[b*x^2 + c*x^4])}
{(b*x^2 + c*x^4)^(3/2)/x^(23/2), x, 8, -((4*c*Sqrt[b*x^2 + c*x^4])/(55*x^(13/2))) - (8*c^2*Sqrt[b*x^2 + c*x^4])/(385*b*x^(9/2)) + (8*c^3*Sqrt[b*x^2 + c*x^4])/(231*b^2*x^(5/2)) - (2*(b*x^2 + c*x^4)^(3/2))/(15*x^(21/2)) + (8*(-c)^(15/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(231*b^(7/4)*Sqrt[b*x^2 + c*x^4])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(13/2)/(b*x^2 + c*x^4)^(1/2), x, 7, (30*b^2*Sqrt[b*x^2 + c*x^4])/(77*c^3*Sqrt[x]) - (18*b*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(77*c^2) + (2*x^(7/2)*Sqrt[b*x^2 + c*x^4])/(11*c) + (30*b^(13/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(77*(-c)^(13/4)*Sqrt[b*x^2 + c*x^4])}
{x^(11/2)/(b*x^2 + c*x^4)^(1/2), x, 6, -((14*b*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(45*c^2)) + (2*x^(5/2)*Sqrt[b*x^2 + c*x^4])/(9*c) + (14*b^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4]) - (14*b^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4])}
{x^(9/2)/(b*x^2 + c*x^4)^(1/2), x, 6, -((10*b*Sqrt[b*x^2 + c*x^4])/(21*c^2*Sqrt[x])) + (2*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(7*c) + (10*b^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(21*(-c)^(9/4)*Sqrt[b*x^2 + c*x^4])}
{x^(7/2)/(b*x^2 + c*x^4)^(1/2), x, 5, (2*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(5*c) + (6*b^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*(-c)^(7/4)*Sqrt[b*x^2 + c*x^4]) - (6*b^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*(-c)^(7/4)*Sqrt[b*x^2 + c*x^4])}
{x^(5/2)/(b*x^2 + c*x^4)^(1/2), x, 5, (2*Sqrt[b*x^2 + c*x^4])/(3*c*Sqrt[x]) + (2*b^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*(-c)^(5/4)*Sqrt[b*x^2 + c*x^4])}
{x^(3/2)/(b*x^2 + c*x^4)^(1/2), x, 4, (2*b^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/((-c)^(3/4)*Sqrt[b*x^2 + c*x^4]) - (2*b^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/((-c)^(3/4)*Sqrt[b*x^2 + c*x^4])}
{x^(1/2)/(b*x^2 + c*x^4)^(1/2), x, 4, (2*b^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/((-c)^(1/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(1/2)*(b*x^2 + c*x^4)^(1/2)), x, 5, -((2*Sqrt[b*x^2 + c*x^4])/(b*x^(3/2))) - (2*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(1/4)*Sqrt[b*x^2 + c*x^4]) + (2*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(1/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(3/2)*(b*x^2 + c*x^4)^(1/2)), x, 5, -((2*Sqrt[b*x^2 + c*x^4])/(3*b*x^(5/2))) + (2*(-c)^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*b^(3/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(5/2)*(b*x^2 + c*x^4)^(1/2)), x, 6, -((2*Sqrt[b*x^2 + c*x^4])/(5*b*x^(7/2))) + (6*c*Sqrt[b*x^2 + c*x^4])/(5*b^2*x^(3/2)) - (6*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*b^(5/4)*Sqrt[b*x^2 + c*x^4]) + (6*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*b^(5/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(7/2)*(b*x^2 + c*x^4)^(1/2)), x, 6, -((2*Sqrt[b*x^2 + c*x^4])/(7*b*x^(9/2))) + (10*c*Sqrt[b*x^2 + c*x^4])/(21*b^2*x^(5/2)) + (10*(-c)^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(21*b^(7/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(9/2)*(b*x^2 + c*x^4)^(1/2)), x, 7, -((2*Sqrt[b*x^2 + c*x^4])/(9*b*x^(11/2))) + (14*c*Sqrt[b*x^2 + c*x^4])/(45*b^2*x^(7/2)) - (14*c^2*Sqrt[b*x^2 + c*x^4])/(15*b^3*x^(3/2)) - (14*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(9/4)*Sqrt[b*x^2 + c*x^4]) + (14*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(9/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(11/2)*(b*x^2 + c*x^4)^(1/2)), x, 7, -((2*Sqrt[b*x^2 + c*x^4])/(11*b*x^(13/2))) + (18*c*Sqrt[b*x^2 + c*x^4])/(77*b^2*x^(9/2)) - (30*c^2*Sqrt[b*x^2 + c*x^4])/(77*b^3*x^(5/2)) + (30*(-c)^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(77*b^(11/4)*Sqrt[b*x^2 + c*x^4])}


{x^(17/2)/(b*x^2 + c*x^4)^(3/2), x, 7, -(x^(11/2)/(c*Sqrt[b*x^2 + c*x^4])) - (15*b*Sqrt[b*x^2 + c*x^4])/(7*c^3*Sqrt[x]) + (9*x^(3/2)*Sqrt[b*x^2 + c*x^4])/(7*c^2) - (15*b^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(7*(-c)^(13/4)*Sqrt[b*x^2 + c*x^4])}
{x^(15/2)/(b*x^2 + c*x^4)^(3/2), x, 6, -(x^(9/2)/(c*Sqrt[b*x^2 + c*x^4])) + (7*Sqrt[x]*Sqrt[b*x^2 + c*x^4])/(5*c^2) - (21*b^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4]) + (21*b^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*(-c)^(11/4)*Sqrt[b*x^2 + c*x^4])}
{x^(13/2)/(b*x^2 + c*x^4)^(3/2), x, 6, -(x^(7/2)/(c*Sqrt[b*x^2 + c*x^4])) + (5*Sqrt[b*x^2 + c*x^4])/(3*c^2*Sqrt[x]) - (5*b^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*(-c)^(9/4)*Sqrt[b*x^2 + c*x^4])}
{x^(11/2)/(b*x^2 + c*x^4)^(3/2), x, 5, -(x^(5/2)/(c*Sqrt[b*x^2 + c*x^4])) - (3*b^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/((-c)^(7/4)*Sqrt[b*x^2 + c*x^4]) + (3*b^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/((-c)^(7/4)*Sqrt[b*x^2 + c*x^4])}
{x^(9/2)/(b*x^2 + c*x^4)^(3/2), x, 5, -(x^(3/2)/(c*Sqrt[b*x^2 + c*x^4])) - (b^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/((-c)^(5/4)*Sqrt[b*x^2 + c*x^4])}
{x^(7/2)/(b*x^2 + c*x^4)^(3/2), x, 5, x^(5/2)/(b*Sqrt[b*x^2 + c*x^4]) - (x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(1/4)*(-c)^(3/4)*Sqrt[b*x^2 + c*x^4]) + (x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(1/4)*(-c)^(3/4)*Sqrt[b*x^2 + c*x^4])}
{x^(5/2)/(b*x^2 + c*x^4)^(3/2), x, 5, x^(3/2)/(b*Sqrt[b*x^2 + c*x^4]) + (x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(3/4)*(-c)^(1/4)*Sqrt[b*x^2 + c*x^4])}
{x^(3/2)/(b*x^2 + c*x^4)^(3/2), x, 6, Sqrt[x]/(b*Sqrt[b*x^2 + c*x^4]) - (3*Sqrt[b*x^2 + c*x^4])/(b^2*x^(3/2)) - (3*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(5/4)*Sqrt[b*x^2 + c*x^4]) + (3*(-c)^(1/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(b^(5/4)*Sqrt[b*x^2 + c*x^4])}
{x^(1/2)/(b*x^2 + c*x^4)^(3/2), x, 6, 1/(b*Sqrt[x]*Sqrt[b*x^2 + c*x^4]) - (5*Sqrt[b*x^2 + c*x^4])/(3*b^2*x^(5/2)) + (5*(-c)^(3/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(3*b^(7/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(1/2)*(b*x^2 + c*x^4)^(3/2)), x, 7, 1/(b*x^(3/2)*Sqrt[b*x^2 + c*x^4]) - (7*Sqrt[b*x^2 + c*x^4])/(5*b^2*x^(7/2)) + (21*c*Sqrt[b*x^2 + c*x^4])/(5*b^3*x^(3/2)) - (21*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*b^(9/4)*Sqrt[b*x^2 + c*x^4]) + (21*(-c)^(5/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(5*b^(9/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(3/2)*(b*x^2 + c*x^4)^(3/2)), x, 7, 1/(b*x^(5/2)*Sqrt[b*x^2 + c*x^4]) - (9*Sqrt[b*x^2 + c*x^4])/(7*b^2*x^(9/2)) + (15*c*Sqrt[b*x^2 + c*x^4])/(7*b^3*x^(5/2)) + (15*(-c)^(7/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(7*b^(11/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(5/2)*(b*x^2 + c*x^4)^(3/2)), x, 8, 1/(b*x^(7/2)*Sqrt[b*x^2 + c*x^4]) - (11*Sqrt[b*x^2 + c*x^4])/(9*b^2*x^(11/2)) + (77*c*Sqrt[b*x^2 + c*x^4])/(45*b^3*x^(7/2)) - (77*c^2*Sqrt[b*x^2 + c*x^4])/(15*b^4*x^(3/2)) - (77*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticE[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(13/4)*Sqrt[b*x^2 + c*x^4]) + (77*(-c)^(9/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(15*b^(13/4)*Sqrt[b*x^2 + c*x^4])}
{1/(x^(7/2)*(b*x^2 + c*x^4)^(3/2)), x, 8, 1/(b*x^(9/2)*Sqrt[b*x^2 + c*x^4]) - (13*Sqrt[b*x^2 + c*x^4])/(11*b^2*x^(13/2)) + (117*c*Sqrt[b*x^2 + c*x^4])/(77*b^3*x^(9/2)) - (195*c^2*Sqrt[b*x^2 + c*x^4])/(77*b^4*x^(5/2)) + (195*(-c)^(11/4)*x*Sqrt[(b + c*x^2)/b]*EllipticF[ArcSin[((-c)^(1/4)*Sqrt[x])/b^(1/4)], -1])/(77*b^(15/4)*Sqrt[b*x^2 + c*x^4])}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^5)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^2+b x^5)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^6/Sqrt[a*x^2 + b*x^5], x, 2, -((4*a*Sqrt[a*x^2 + b*x^5])/(9*b^2*x)) + (2*x^2*Sqrt[a*x^2 + b*x^5])/(9*b)}
(* {x^5/Sqrt[a*x^2 + b*x^5], x, 8, (2*x*Sqrt[a*x^2 + b*x^5])/(7*b) + (2*Sqrt[2]*3^(1/4)*a^(7/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticE[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(7*b^(13/6)*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[a*x^2 + b*x^5]) - (2*Sqrt[2]*3^(1/4)*a^(3/2)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3))*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticF[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(7*b^(13/6)*Sqrt[a*x^2 + b*x^5])} *)
{x^4/Sqrt[a*x^2 + b*x^5], x, 5, (2*Sqrt[a*x^2 + b*x^5])/(5*b) - (2*Sqrt[2]*3^(1/4)*a^(7/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticF[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(5*b^(3/2)*Sqrt[a*x^2 + b*x^5])}
{x^3/Sqrt[a*x^2 + b*x^5], x, 1, (2*Sqrt[a*x^2 + b*x^5])/(3*b*x)}
{x^2/Sqrt[a*x^2 + b*x^5], x, 7, -((3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticE[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(Sqrt[2]*b^(7/6)*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[a*x^2 + b*x^5])) + (3^(1/4)*Sqrt[a]*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3))*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticF[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(Sqrt[2]*b^(7/6)*Sqrt[a*x^2 + b*x^5])}
{x^1/Sqrt[a*x^2 + b*x^5], x, 4, (Sqrt[2]*3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticF[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(Sqrt[b]*Sqrt[a*x^2 + b*x^5])}
{x^0/Sqrt[a*x^2 + b*x^5], x, 1, -((2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^5]])/(3*Sqrt[a]))}
(* {1/(x^1*Sqrt[a*x^2 + b*x^5]), x, 8, -(Sqrt[a*x^2 + b*x^5]/(a*x^2)) - (3^(1/4)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticE[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(2*Sqrt[2]*a^(5/6)*b^(1/6)*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[a*x^2 + b*x^5]) + (3^(1/4)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3))*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*x*Sqrt[a^(1/3) + b^(1/3)*x]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticF[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(2*Sqrt[2]*Sqrt[a]*b^(1/6)*Sqrt[a*x^2 + b*x^5])} *)
{1/(x^2*Sqrt[a*x^2 + b*x^5]), x, 5, -(Sqrt[a*x^2 + b*x^5]/(2*a*x^3)) - (3^(1/4)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)]*Sqrt[b]*x*Sqrt[a^(1/3) + b^(1/3)*x]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)) - 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))]*Sqrt[(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)) + 2*b^(2/3)*x)/(a^(1/3)*(Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3)))]*EllipticF[ArcSin[(Sqrt[2]*b^(1/6)*Sqrt[a^(1/3) + b^(1/3)*x])/(3^(1/4)*a^(1/6)*Sqrt[-Sqrt[-b^(2/3)] + Sqrt[3]*b^(1/3)])], -((Sqrt[3]*Sqrt[-b^(2/3)] - 3*b^(1/3))/(Sqrt[3]*Sqrt[-b^(2/3)] + 3*b^(1/3)))])/(2*Sqrt[2]*a^(5/6)*Sqrt[a*x^2 + b*x^5])}
{1/(x^3*Sqrt[a*x^2 + b*x^5]), x, 2, -(Sqrt[a*x^2 + b*x^5]/(3*a*x^4)) + (b*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^5]])/(3*a^(3/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a x^2+b x^5)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(13/2)/(a*x^2 + b*x^5)^(1/2), x, 5, -((7*a*Sqrt[a*x^2 + b*x^5])/(20*b^2*Sqrt[x])) + (x^(5/2)*Sqrt[a*x^2 + b*x^5])/(5*b) + (7*a^(5/3)*x^(3/2)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(40*3^(1/4)*b^2*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x^2 + b*x^5])}
{x^(11/2)/(a*x^2 + b*x^5)^(1/2), x, 4, (x^(3/2)*Sqrt[a*x^2 + b*x^5])/(4*b) - (a*x^(7/2)*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(4*b*Sqrt[a*x^2 + b*x^5])}
{x^(9/2)/(a*x^2 + b*x^5)^(1/2), x, 2, (Sqrt[x]*Sqrt[a*x^2 + b*x^5])/(3*b) - (a*ArcTanh[(Sqrt[b]*x^(5/2))/Sqrt[a*x^2 + b*x^5]])/(3*b^(3/2))}
{x^(7/2)/(a*x^2 + b*x^5)^(1/2), x, 4, Sqrt[a*x^2 + b*x^5]/(2*b*Sqrt[x]) - (a^(2/3)*x^(3/2)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(4*3^(1/4)*b*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x^2 + b*x^5])}
{x^(5/2)/(a*x^2 + b*x^5)^(1/2), x, 3, (2*x^(7/2)*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(5*Sqrt[a*x^2 + b*x^5])}
{x^(3/2)/(a*x^2 + b*x^5)^(1/2), x, 1, (2*ArcTanh[(Sqrt[b]*x^(5/2))/Sqrt[a*x^2 + b*x^5]])/(3*Sqrt[b])}
{x^(1/2)/(a*x^2 + b*x^5)^(1/2), x, 3, (x^(3/2)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(3^(1/4)*a^(1/3)*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x^2 + b*x^5])}
{1/(x^(1/2)*(a*x^2 + b*x^5)^(1/2)), x, 4, -((2*Sqrt[a*x^2 + b*x^5])/(a*x^(3/2))) + (4*b*x^(7/2)*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(5*a*Sqrt[a*x^2 + b*x^5])}
{1/(x^(3/2)*(a*x^2 + b*x^5)^(1/2)), x, 1, -((2*Sqrt[a*x^2 + b*x^5])/(3*a*x^(5/2)))}
{1/(x^(5/2)*(a*x^2 + b*x^5)^(1/2)), x, 4, -((2*Sqrt[a*x^2 + b*x^5])/(5*a*x^(7/2))) - (2*b*x^(3/2)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(5*3^(1/4)*a^(4/3)*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x^2 + b*x^5])}
{1/(x^(7/2)*(a*x^2 + b*x^5)^(1/2)), x, 5, -((2*Sqrt[a*x^2 + b*x^5])/(7*a*x^(9/2))) + (8*b*Sqrt[a*x^2 + b*x^5])/(7*a^2*x^(3/2)) - (16*b^2*x^(7/2)*Sqrt[(a + b*x^3)/a]*Hypergeometric2F1[1/2, 5/6, 11/6, -((b*x^3)/a)])/(35*a^2*Sqrt[a*x^2 + b*x^5])}
{1/(x^(9/2)*(a*x^2 + b*x^5)^(1/2)), x, 2, -((2*Sqrt[a*x^2 + b*x^5])/(9*a*x^(11/2))) + (4*b*Sqrt[a*x^2 + b*x^5])/(9*a^2*x^(5/2))}
{1/(x^(11/2)*(a*x^2 + b*x^5)^(1/2)), x, 5, -((2*Sqrt[a*x^2 + b*x^5])/(11*a*x^(13/2))) + (16*b*Sqrt[a*x^2 + b*x^5])/(55*a^2*x^(7/2)) + (16*b^2*x^(3/2)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*EllipticF[ArcCos[(a^(1/3) + (1 - Sqrt[3])*b^(1/3)*x)/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)], (1/4)*(2 + Sqrt[3])])/(55*3^(1/4)*a^(7/3)*Sqrt[(b^(1/3)*x*(a^(1/3) + b^(1/3)*x))/(a^(1/3) + (1 + Sqrt[3])*b^(1/3)*x)^2]*Sqrt[a*x^2 + b*x^5])}


(* ::Title:: *)
(*Integration problems of the form x^m (a x^3+b x^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x^3+b x^4)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^3+b x^4)^n*)


{x/(a*x^3 + b*x^4), x, 3, -(1/(a*x)) - (b*Log[x])/a^2 + (b*Log[a + b*x])/a^2}
{1/(a*x^3 + b*x^4), x, 3, -(1/(2*a*x^2)) + b/(a^2*x) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x])/a^3}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a x^3+b x^4)^(p/2)*)


{x^4/Sqrt[a*x^3 + b*x^4], x, 4, -((5*a*Sqrt[a*x^3 + b*x^4])/(12*b^2)) + (5*a^2*Sqrt[a*x^3 + b*x^4])/(8*b^3*x) + (x*Sqrt[a*x^3 + b*x^4])/(3*b) - (5*a^3*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x^3 + b*x^4]])/(8*b^(7/2))}
{x^3/Sqrt[a*x^3 + b*x^4], x, 3, Sqrt[a*x^3 + b*x^4]/(2*b) - (3*a*Sqrt[a*x^3 + b*x^4])/(4*b^2*x) + (3*a^2*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x^3 + b*x^4]])/(4*b^(5/2))}
{x^2/Sqrt[a*x^3 + b*x^4], x, 2, Sqrt[a*x^3 + b*x^4]/(b*x) - (a*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x^3 + b*x^4]])/b^(3/2)}
{x^1/Sqrt[a*x^3 + b*x^4], x, 1, (2*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x^3 + b*x^4]])/Sqrt[b]}
{x^0/Sqrt[a*x^3 + b*x^4], x, 1, -((2*Sqrt[a*x^3 + b*x^4])/(a*x^2))}
{1/(x^1*Sqrt[a*x^3 + b*x^4]), x, 2, -((2*Sqrt[a*x^3 + b*x^4])/(3*a*x^3)) + (4*b*Sqrt[a*x^3 + b*x^4])/(3*a^2*x^2)}
{1/(x^2*Sqrt[a*x^3 + b*x^4]), x, 3, -((2*Sqrt[a*x^3 + b*x^4])/(5*a*x^4)) + (8*b*Sqrt[a*x^3 + b*x^4])/(15*a^2*x^3) - (16*b^2*Sqrt[a*x^3 + b*x^4])/(15*a^3*x^2)}
{1/(x^3*Sqrt[a*x^3 + b*x^4]), x, 4, -((2*Sqrt[a*x^3 + b*x^4])/(7*a*x^5)) + (12*b*Sqrt[a*x^3 + b*x^4])/(35*a^2*x^4) - (16*b^2*Sqrt[a*x^3 + b*x^4])/(35*a^3*x^3) + (32*b^3*Sqrt[a*x^3 + b*x^4])/(35*a^4*x^2)}
{1/(x^4*Sqrt[a*x^3 + b*x^4]), x, 5, -((2*Sqrt[a*x^3 + b*x^4])/(9*a*x^6)) + (16*b*Sqrt[a*x^3 + b*x^4])/(63*a^2*x^5) - (32*b^2*Sqrt[a*x^3 + b*x^4])/(105*a^3*x^4) + (128*b^3*Sqrt[a*x^3 + b*x^4])/(315*a^4*x^3) - (256*b^4*Sqrt[a*x^3 + b*x^4])/(315*a^5*x^2)}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x^3+b x^5)^p*)


(* ::Subsection:: *)
(*Integrands of the form x^m (a x^3+b x^5)^n*)


(* ::Subsection:: *)
(*Integrands of the form x^m (a x^3+b x^5)^(p/2)*)


(* ::Title:: *)
(*Integration problems of the form x^m (a x^q+b x^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a x^q+b x^n)^p*)


{1/(a*x + b*x), x, 3, Log[x]/(a + b)}

{1/(x^3 + b*x^5), x, 3, -(1/(2*x^2)) + b*ArcTanh[1 + 2*b*x^2]}
{1/(-x^3 + b*x^5), x, 3, 1/(2*x^2) + b*ArcTanh[1 - 2*b*x^2]}

{1/(-x^3 + x^6), x, 7, 1/(2*x^2) - ArcTan[(1 + 2*x)/Sqrt[3]]/Sqrt[3] + (1/3)*Log[1 - x] - (1/6)*Log[1 + x + x^2]}

{x^11/(a*x^2 + b*x^5)^3, x, 2, x^6/(6*a*(a + b*x^3)^2)}


{1/(x^2*Sqrt[a/x^2 + b*x^n]), x, 1, -((2*ArcTanh[Sqrt[a]/(x*Sqrt[a/x^2 + b*x^n])])/(Sqrt[a]*(2 + n)))}


{Sqrt[a*x^r + b/x^2], x, 2, (2*x*Sqrt[b/x^2 + a*x^r])/(2 + r) - (2*Sqrt[b]*ArcTanh[Sqrt[b]/(x*Sqrt[b/x^2 + a*x^r])])/(2 + r)}
{Sqrt[(a + b*x)/x^2], x, 4, 2*Sqrt[a/x^2 + b/x]*x - 2*Sqrt[a]*ArcTanh[Sqrt[a]/(Sqrt[a/x^2 + b/x]*x)]}
{Sqrt[(a + b*x^2)/x^2], x, 4, Sqrt[b + a/x^2]*x - Sqrt[a]*ArcTanh[Sqrt[a]/(Sqrt[b + a/x^2]*x)]}
{Sqrt[(a + b*x^3)/x^2], x, 3, (2/3)*x*Sqrt[a/x^2 + b*x] - (2/3)*Sqrt[a]*ArcTanh[Sqrt[a]/(x*Sqrt[a/x^2 + b*x])]}
{Sqrt[(a + b*x^n)/x^2], x, 3, (2*x*Sqrt[a/x^2 + b*x^(-2 + n)])/n - (2*Sqrt[a]*ArcTanh[Sqrt[a]/(x*Sqrt[a/x^2 + b*x^(-2 + n)])])/n}

{Sqrt[(-a + b*x)/x^2], x, 4, 2*Sqrt[-(a/x^2) + b/x]*x + 2*Sqrt[a]*ArcTan[Sqrt[a]/(Sqrt[-(a/x^2) + b/x]*x)]}
{Sqrt[(-a + b*x^2)/x^2], x, 4, Sqrt[b - a/x^2]*x + Sqrt[a]*ArcTan[Sqrt[a]/(Sqrt[b - a/x^2]*x)]}
{Sqrt[(-a + b*x^3)/x^2], x, 3, (2/3)*x*Sqrt[-(a/x^2) + b*x] + (2/3)*Sqrt[a]*ArcTan[Sqrt[a]/(x*Sqrt[-(a/x^2) + b*x])]}
{Sqrt[(-a + b*x^n)/x^2], x, 3, (2*x*Sqrt[-(a/x^2) + b*x^(-2 + n)])/n + (2*Sqrt[a]*ArcTan[Sqrt[a]/(x*Sqrt[-(a/x^2) + b*x^(-2 + n)])])/n}


{x^(-1 - (n - 1)/2)*Sqrt[a*x^(n - 1) + b*x^n], x, 2, 2*x^((1 - n)/2)*Sqrt[a*x^(-1 + n) + b*x^n] - 2*Sqrt[a]*ArcTanh[(Sqrt[a]*x^((1/2)*(-1 + n)))/Sqrt[a*x^(-1 + n) + b*x^n]]}


{Sqrt[(1 + x)/x^5], x, 2, (-(2/3))*(1/x^5 + 1/x^4)^(3/2)*x^6}
{Sqrt[x + x^(5/2)], x, 1, (4*(x + x^(5/2))^(3/2))/(9*x^(3/2))}
{1/(Sqrt[x] + x^(3/2)), x, 2, 2*ArcTan[Sqrt[x]]}

{x*Sqrt[x^2*(a + b*x^3)], x, 2, (2*(a*x^2 + b*x^5)^(3/2))/(9*b*x^3)}
{x*Sqrt[a*x^2 + b*x^5], x, 1, (2*(a*x^2 + b*x^5)^(3/2))/(9*b*x^3)}


{1/(a*x + b/x), x, 2, Log[b + a*x^2]/(2*a)}
{1/(a*x + b/x^2), x, 2, Log[b + a*x^3]/(3*a)}
{1/(a*x + b/x^3), x, 2, Log[b + a*x^4]/(4*a)}
{1/(a*x + b/x)^3, x, 2, x^4/(4*b*(b + a*x^2)^2)}

{1/(a*x^2 + b/x^3)^3, x, 2, x^10/(10*b*(b + a*x^5)^2)}
{1/(a*x^3 + b/x^5)^3, x, 2, x^16/(16*b*(b + a*x^8)^2)}


{(a/x + b*x)^2, x, 3, -(a^2/x) + 2*a*b*x + (b^2*x^3)/3}
{(a/x + b*x)^3, x, 3, -(a^3/(2*x^2)) + (3/2)*a*b^2*x^2 + (b^3*x^4)/4 + 3*a^2*b*Log[x]}
{(a/x + b*x)^4, x, 3, -(a^4/(3*x^3)) - (4*a^3*b)/x + 6*a^2*b^2*x + (4/3)*a*b^3*x^3 + (b^4*x^5)/5}


{1/(1/x^2 + x^3), x, 9, (-(1/10))*(1 - Sqrt[5])*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[2*(5 + Sqrt[5])]] - (1/10)*Sqrt[(1/2)*(5 - Sqrt[5])]*(1 + Sqrt[5])*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[2*(5 - Sqrt[5])]] + (1/5)*Log[1 + x] - (1/20)*(1 + Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] - (1/20)*(1 - Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}


{(a*x^q + b*x^n)^(3/2), x, 3, (6*a*(n - q)*x^(1 + q)*Sqrt[b*x^n + a*x^q])/((2 + 3*n)*(2 + n + 2*q)) + (2*x*(b*x^n + a*x^q)^(3/2))/(2 + 3*n) + (6*a^2*(n - q)^2*x^(1 + 2*q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 + (3*q)/2)/(n - q), (2 + 2*n + q)/(2*(n - q)), -((b*x^(n - q))/a)])/((2 + 3*n)*(2 + n + 2*q)*(2 + 3*q)*Sqrt[b*x^n + a*x^q])}
{(a*x^q + b*x^n)^(1/2), x, 2, (2*x*Sqrt[b*x^n + a*x^q])/(2 + n) + (2*a*(n - q)*x^(1 + q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (2 + q)/(2*(n - q)), 1 + (2 + q)/(2*n - 2*q), -((b*x^(n - q))/a)])/((2 + n)*(2 + q)*Sqrt[b*x^n + a*x^q])}
{1/(a*x^q + b*x^n)^(1/2), x, 1, (2*x*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (2 - q)/(2*(n - q)), (1/2)*(2 + (2 - q)/(n - q)), -((b*x^(n - q))/a)])/((2 - q)*Sqrt[b*x^n + a*x^q])}
{1/(a*x^q + b*x^n)^(3/2), x, 2, (2*x^(1 - q))/(a*(n - q)*Sqrt[b*x^n + a*x^q]) - (2*(2 - n - 2*q)*x^(1 - q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 - (3*q)/2)/(n - q), 1 + (2 - 3*q)/(2*n - 2*q), -((b*x^(n - q))/a)])/(a*(2 - 3*q)*(n - q)*Sqrt[b*x^n + a*x^q])}
{1/(a*x^q + b*x^n)^(5/2), x, 3, (2*x^(1 - q))/(3*a*(n - q)*(b*x^n + a*x^q)^(3/2)) - (2*(2 - 3*n - 2*q)*x^(1 - 2*q))/(3*a^2*(n - q)^2*Sqrt[b*x^n + a*x^q]) + (2*(2 - n - 4*q)*(2 - 3*n - 2*q)*x^(1 - 2*q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 - (5*q)/2)/(n - q), 1 + (2 - 5*q)/(2*n - 2*q), -((b*x^(n - q))/a)])/(3*a^2*(2 - 5*q)*(n - q)^2*Sqrt[b*x^n + a*x^q])}


{x^m*(a*x^q + b*x^n)^(3/2), x, 3, (6*a*(n - q)*x^(1 + m + q)*Sqrt[b*x^n + a*x^q])/((2 + 2*m + 3*n)*(2 + 2*m + n + 2*q)) + (2*x^(1 + m)*(b*x^n + a*x^q)^(3/2))/(2 + 2*m + 3*n) + (6*a^2*(n - q)^2*x^(1 + m + 2*q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 + m + (3*q)/2)/(n - q), 1 + (1 + m + (3*q)/2)/(n - q), -((b*x^(n - q))/a)])/((2 + 2*m + 3*n)*(2 + 2*m + n + 2*q)*(2 + 2*m + 3*q)*Sqrt[b*x^n + a*x^q])}
{x^m*(a*x^q + b*x^n)^(1/2), x, 2, (2*x^(1 + m)*Sqrt[b*x^n + a*x^q])/(2 + 2*m + n) + (2*a*(n - q)*x^(1 + m + q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 + m + q/2)/(n - q), 1 + (2 + 2*m + q)/(2*n - 2*q), -((b*x^(n - q))/a)])/((2 + 2*m + n)*(2 + 2*m + q)*Sqrt[b*x^n + a*x^q])}
{x^m/(a*x^q + b*x^n)^(1/2), x, 1, (2*x^(1 + m)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 + m - q/2)/(n - q), 1 + (1 + m - q/2)/(n - q), -((b*x^(n - q))/a)])/((2 + 2*m - q)*Sqrt[b*x^n + a*x^q])}
{x^m/(a*x^q + b*x^n)^(3/2), x, 2, (2*x^(1 + m - q))/(a*(n - q)*Sqrt[b*x^n + a*x^q]) - (2*(2 + 2*m - n - 2*q)*x^(1 + m - q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 + m - (3*q)/2)/(n - q), 1 + (1 + m - (3*q)/2)/(n - q), -((b*x^(n - q))/a)])/(a*(2 + 2*m - 3*q)*(n - q)*Sqrt[b*x^n + a*x^q])}
{x^m/(a*x^q + b*x^n)^(5/2), x, 3, (2*x^(1 + m - q))/(3*a*(n - q)*(b*x^n + a*x^q)^(3/2)) - (2*(2 + 2*m - 3*n - 2*q)*x^(1 + m - 2*q))/(3*a^2*(n - q)^2*Sqrt[b*x^n + a*x^q]) + (2*(2 + 2*m - n - 4*q)*(2 + 2*m - 3*n - 2*q)*x^(1 + m - 2*q)*Sqrt[(b*x^n + a*x^q)/(x^q*a)]*Hypergeometric2F1[1/2, (1 + m - (5*q)/2)/(n - q), 1 + (1 + m - (5*q)/2)/(n - q), -((b*x^(n - q))/a)])/(3*a^2*(2 + 2*m - 5*q)*(n - q)^2*Sqrt[b*x^n + a*x^q])}


{x^m*(a*x^q + b*x^n)^p, x, 1, (x^(1 + m)*(b*x^n + a*x^q)^p*Hypergeometric2F1[-p, (1 + m + p*q)/(n - q), 1 + (1 + m + p*q)/(n - q), -((b*x^(n - q))/a)])/(((b*x^n + a*x^q)/(x^q*a))^p*(1 + m + p*q))}
{(a*x^q + b*x^n)^p/x^(p*q + 1), x, 1, ((b*x^n + a*x^q)^p*Hypergeometric2F1[-p, -p, 1 - p, -((a*x^(-n + q))/b)])/(x^(p*q)*((b*x^n + a*x^q)/(x^n*b))^p*(p*(n - q)))}
{(a*x^q + b*x^n)^p/x^(p*n + 1), x, 1, -(((b*x^n + a*x^q)^p*Hypergeometric2F1[-p, -p, 1 - p, -((b*x^(n - q))/a)])/(x^(n*p)*((b*x^n + a*x^q)/(x^q*a))^p*(p*(n - q))))}
{(a*x^q + b*x^n)^p/x^(n + (p - 1)*q +1), x, 2, -((x^(-n - p*q)*(b*x^n + a*x^q)^(1 + p))/(a*(n - q))) + (b*(b*x^n + a*x^q)^p*Hypergeometric2F1[-p, -p, 1 - p, -((a*x^(-n + q))/b)])/(x^(p*q)*((b*x^n + a*x^q)/(x^n*b))^p*(a*(n - q)))}
{(a*x^q + b*x^n)^p/x^(q + (p - 1)*n +1), x, 2, (x^((-n)*p - q)*(b*x^n + a*x^q)^(1 + p))/(b*(n - q)) - (a*(b*x^n + a*x^q)^p*Hypergeometric2F1[-p, -p, 1 - p, -((b*x^(n - q))/a)])/(x^(n*p)*((b*x^n + a*x^q)/(x^q*a))^p*(b*(n - q)))}


{(a*x^m + b*x^(m*p + m + 1))^p, x, 1, (a*x^m + b*x^(1 + m + m*p))^(1 + p)/(x^(m*(1 + p))*(b*(1 + p)*(1 + m*p)))}
{(x^m*(a + b*x^(m*p + 1)))^p, x, 2, (a*x^m + b*x^(1 + m + m*p))^(1 + p)/(x^(m*(1 + p))*(b*(1 + p)*(1 + m*p)))}

{x^n*(x^m*(a + b*x^(m*p + n + 1)))^p, x, 2, (a*x^m + b*x^(1 + m + n + m*p))^(1 + p)/(x^(m*(1 + p))*(b*(1 + p)*(1 + n + m*p)))}
{x^n*(a*x^m + b*x^(m*p + m + n + 1))^p, x, 1, (a*x^m + b*x^(1 + m + n + m*p))^(1 + p)/(x^(m*(1 + p))*(b*(1 + p)*(1 + n + m*p)))}


{Sqrt[x^4*(a + b*x^3)], x, 2, (2*(a*x^4 + b*x^7)^(3/2))/(9*b*x^6)}


{(x^(2*(n - 1))*(a + b*x^n))^(1/2), x, 2, (2*x^(3*(1 - n))*(a/x^(2*(1 - n)) + b*x^(-2 + 3*n))^(3/2))/(3*b*n)}
{(x^(3*(n - 1))*(a + b*x^n))^(1/3), x, 2, (3*x^(4*(1 - n))*(a/x^(3*(1 - n)) + b*x^(-3 + 4*n))^(4/3))/(4*b*n)}
{(x^(4*(n - 1))*(a + b*x^n))^(1/4), x, 2, (4*x^(5*(1 - n))*(a/x^(4*(1 - n)) + b*x^(-4 + 5*n))^(5/4))/(5*b*n)}
{(x^(p*(n - 1))*(a + b*x^n))^(1/p), x, 2, (p*x^((1 - n)*(1 + p))*(a/x^((1 - n)*p) + b*x^(n - (1 - n)*p))^(1 + 1/p))/(b*n*(1 + p))}


{(x^((n - 1)/p)*(a + b*x^n))^p, x, 2, (x^(((1 - n)*(1 + p))/p)*(b*x^(n - (1 - n)/p) + a/x^((1 - n)/p))^(1 + p))/(b*n*(1 + p))}


(* Integrands of the form x^(12*(m-1))*(a*x + b*x^(12*m+2))^12 *)
{(a*x + b*x^14)^12, x, 2, (a + b*x^13)^13/(169*b)}
{x^12*(a*x + b*x^26)^12, x, 2, (a + b*x^25)^13/(325*b)}
{x^24*(a*x + b*x^38)^12, x, 2, (a + b*x^37)^13/(481*b)}
{x^(12*(m-1))*(a*x + b*x^(12*m + 2))^12, x, 2, (a + b*x^(1 + 12*m))^13/(13*b*(1 + 12*m))}

(* Integrands of the form (a*x^m + b*x^(12*m+m+1))^12 *)
{(a*x + b*x^14)^12, x, 2, (a + b*x^13)^13/(169*b)}
{(a*x^2 + b*x^27)^12, x, 2, (a + b*x^25)^13/(325*b)}
{(a*x^3 + b*x^40)^12, x, 2, (a + b*x^37)^13/(481*b)}
{(a*x^m + b*x^(12*m + m + 1))^12, x, 2, (a + b*x^(1 + 12*m))^13/(13*b*(1 + 12*m))}


(* Integrands of the form x^p*(a*x^n+b*x^(m*n+n+p+1))^m *)
{x^p*(a*x^n + b*x^(12*n + n + p + 1))^12, x, 2, (a + b*x^(1 + 12*n + p))^13/(13*b*(1 + 12*n + p))}

{x^12*(a + b*x^13)^12, x, 1, (a + b*x^13)^13/(169*b)}
{x^12*(a*x + b*x^26)^12, x, 2, (a + b*x^25)^13/(325*b)}
{x^12*(a*x^2 + b*x^39)^12, x, 2, (a + b*x^37)^13/(481*b)}

{x^24*(a + b*x^25)^12, x, 1, (a + b*x^25)^13/(325*b)}
{x^24*(a*x + b*x^38)^12, x, 2, (a + b*x^37)^13/(481*b)}

{x^36*(a + b*x^37)^12, x, 1, (a + b*x^37)^13/(481*b)}


{1/(a*x + b*x^n), x, 2, Log[b + a*x^(1 - n)]/(a*(1 - n))}
{1/(a*x + b*x^(n + 1)), x, 2, Log[x]/a - Log[a + b*x^n]/(a*n)}
{1/(a*x + b/x^(n - 1)), x, 2, Log[b + a*x^n]/(a*n)}
{1/(2*x + 3*x^(n+1)), x, 2, -ArcTanh[1 + 3*x^n]/n}
{1/(2*x + 3/x^(n-1)), x, 2, Log[3 + 2*x^n]/(2*n)}

{1/(-Sqrt[x] + x), x, 2, 2*Log[1 - Sqrt[x]]}
{1/(-x^(3/5) + x), x, 2, (5/2)*Log[1 - x^(2/5)]}
{1/(x^(-1/3) + x), x, 2, (3*Log[1 + x^(4/3)])/4}
{1/(x + x^Sqrt[2]), x, 2, -2*(1 + Sqrt[2])*ArcTanh[1 + 2*x^(-1 + Sqrt[2])]}


{x^(-1 + n - p*(1 + q))*(a*x^n + b*x^p)^q, x, 1, (a*x^n + b*x^p)^(1 + q)/(x^(p*(1 + q))*(a*(n - p)*(1 + q)))}
{x^(-1 - n*q - p*(1 + q))*(x^n*(a + b*x^p))^q, x, 2, -((a*x^n + b*x^(n + p))^(1 + q)/(x^((n + p)*(1 + q))*(a*p*(1 + q))))}


{1/(a*x^2 + b*x^2), x, 3, -(1/((a + b)*x))}


{1/Sqrt[a*x^r + b*x^2], x, 1, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + a*x^r]])/(Sqrt[b]*(2 - r))}
{1/Sqrt[a*x^r - b*x^2], x, 1, (2*ArcTan[(Sqrt[b]*x)/Sqrt[(-b)*x^2 + a*x^r]])/(Sqrt[b]*(2 - r))}

{1/Sqrt[(a + b*x^3)/x], x, 2, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[a/x + b*x^2]])/(3*Sqrt[b])}
{1/Sqrt[(a + b*x^4)/x^2], x, 2, ArcTanh[(Sqrt[b]*x)/Sqrt[a/x^2 + b*x^2]]/(2*Sqrt[b])}
{1/Sqrt[(a + b*x^5)/x^3], x, 2, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[a/x^3 + b*x^2]])/(5*Sqrt[b])}
{1/Sqrt[(a + b*x^n)/x^(n-2)], x, 2, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + a*x^(2 - n)]])/(Sqrt[b]*n)}

{1/Sqrt[(a - b*x^3)/x], x, 2, (2*ArcTan[(Sqrt[b]*x)/Sqrt[a/x - b*x^2]])/(3*Sqrt[b])}
{1/Sqrt[(a - b*x^4)/x^2], x, 2, ArcTan[(Sqrt[b]*x)/Sqrt[a/x^2 - b*x^2]]/(2*Sqrt[b])}
{1/Sqrt[(a - b*x^5)/x^3], x, 2, (2*ArcTan[(Sqrt[b]*x)/Sqrt[a/x^3 - b*x^2]])/(5*Sqrt[b])}
{1/Sqrt[(a - b*x^n)/x^(n-2)], x, 2, (2*ArcTan[(Sqrt[b]*x)/Sqrt[(-b)*x^2 + a*x^(2 - n)]])/(Sqrt[b]*n)}

{1/Sqrt[x^n*(a + b*x^(2 - n))], x, 2, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + a*x^n]])/(Sqrt[b]*(2 - n))}
{1/Sqrt[x^2*(b + a*x^(-2 + n))], x, 2, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + a*x^n]])/(Sqrt[b]*(2 - n))}
{1/Sqrt[x*(b*x + a*x^(-1 + n))], x, 2, (2*ArcTanh[(Sqrt[b]*x)/Sqrt[b*x^2 + a*x^n]])/(Sqrt[b]*(2 - n))}

{1/Sqrt[x^n*(a - b*x^(2 - n))], x, 2, (2*ArcTan[(Sqrt[b]*x)/Sqrt[(-b)*x^2 + a*x^n]])/(Sqrt[b]*(2 - n))}
{1/Sqrt[x^2*(-b + a*x^(-2 + n))], x, 2, (2*ArcTan[(Sqrt[b]*x)/Sqrt[(-b)*x^2 + a*x^n]])/(Sqrt[b]*(2 - n))}
{1/Sqrt[x*(-b*x + a*x^(-1 + n))], x, 2, (2*ArcTan[(Sqrt[b]*x)/Sqrt[(-b)*x^2 + a*x^n]])/(Sqrt[b]*(2 - n))}


(* ::Title::Closed:: *)
(*Integration problems of the form (a+b x^n)^m (c x^r+d x^s)^p*)


{(4 + 3*x^4)/(5*x + 2*x^5), x, 3, (4*Log[x])/5 + (7*Log[5 + 2*x^4])/40}
{(1 + x^6)/(x - x^7), x, 3, Log[x] - Log[1 - x^6]/3}
{(8 + 5*x^10)/(2*x - x^11), x, 3, 4*Log[x] - (9/10)*Log[2 - x^10]}
{(-3 + 2*x)/(-x^2 + x^3), x, 3, -(3/x) - Log[1 - x] + Log[x]}


(* ::Title::Closed:: *)
(*Integration problems of the form x^m (a x^q+b x^n)^m (c x^r+d x^s)^p*)


{(a*x^m + b*x^n)/(c*x^m + d*x^n), x, 3, (a*x)/c + ((b*c - a*d)*x*Hypergeometric2F1[1, 1/(m - n), 1 + 1/(m - n), -((c*x^(m - n))/d)])/(c*d)}


{x^m*(a*(m + q + 1)*x^q + b*(m + q + n*(p + 1) + 1)*x^(n + q))*(a + b*x^n)^p, x, 2, x^(1 + m + q)*(a + b*x^n)^(1 + p)}
